/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.certificate.attribute.AbstractSingleValueAttribute;
import de.intarsys.tools.currency.Iso4217;
import java.text.NumberFormat;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;

public class ISISMTTQcEuLimitValue
extends AbstractSingleValueAttribute {
    public static final String OID = ETSIQCObjectIdentifiers.id_etsi_qcs_LimiteValue.getId();
    private static NumberFormat CURRENCY_FORMAT = null;

    public ISISMTTQcEuLimitValue(Attribute attribute) {
        super(attribute);
    }

    public int getAmount() {
        return this.getAttributeValue().getChild(1).toDERInteger().getValue().intValue();
    }

    public String getCurrency() {
        ASN1ValueHolder iso4217CurrencyCode = this.getAttributeValue().getChild(0);
        if (ASN1Tools.isInstanceOf((ASN1Encodable)iso4217CurrencyCode, DERPrintableString.class)) {
            return iso4217CurrencyCode.toASN1PrintableString().getString();
        }
        int numeric = iso4217CurrencyCode.toDERInteger().getValue().intValue();
        return Iso4217.Numeric2Alphabetic((int)numeric);
    }

    public int getExponent() {
        return this.getAttributeValue().getChild(2).toDERInteger().getValue().intValue();
    }

    @Override
    public String getLabel() {
        return Msg.getString("ISISMTTQcEuLimitValue.Label", new Object[0]);
    }

    public double getLimit() {
        return (double)this.getAmount() * Math.pow(10.0, this.getExponent());
    }

    @Override
    public String getStringValue() {
        return CURRENCY_FORMAT.format(this.getLimit()) + " " + this.getCurrency();
    }

    @Override
    public String getStringValue(int index) {
        return this.getStringValue();
    }

    protected ASN1ValueHolder getAttributeValue() {
        return this.getAttribute().getAttrValue(0);
    }

    static {
        CURRENCY_FORMAT = NumberFormat.getInstance();
        CURRENCY_FORMAT.setMinimumIntegerDigits(1);
        CURRENCY_FORMAT.setMinimumFractionDigits(2);
        CURRENCY_FORMAT.setMaximumFractionDigits(2);
    }
}

