/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes.basic;

import de.intarsys.security.app.validation.CommonValidationContextDecorator;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.common.DecoratedCertificateValidator;
import de.intarsys.security.app.validation.common.DecoratedSignatureEntryValidator;
import de.intarsys.security.app.validation.common.DecoratedTimestampValidator;
import de.intarsys.security.app.validation.commonpki.ValidationContextProxy;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.app.validation.commonpki.qes.QualificationSeverity;
import de.intarsys.security.app.validation.commonpki.qes.basic.QESBasicCertificateReviewer;
import de.intarsys.security.app.validation.commonpki.qes.basic.QESBasicSignatureEntryReviewer;
import de.intarsys.security.app.validation.commonpki.qes.basic.QESBasicTimestampReviewer;
import de.intarsys.tools.functor.IArgs;

public class QESBasicValidationContextDecorator
extends CommonValidationContextDecorator {
    protected IValidationContext basicDecorate(IValidationContext context, IArgs args) {
        int severity = QualificationSeverity.get(args, null).getValue();
        ValidationContextProxy myContext = new ValidationContextProxy(context);
        DecoratedCertificateValidator certificateValidator = new DecoratedCertificateValidator(context.getCertificateValidator());
        certificateValidator.addReviewer(new QESBasicCertificateReviewer(severity));
        myContext.setCertificateValidator(certificateValidator);
        DecoratedSignatureEntryValidator signatureEntryValidator = new DecoratedSignatureEntryValidator(context.getSignatureEntryValidator());
        signatureEntryValidator.addReviewer(new QESBasicSignatureEntryReviewer(severity));
        myContext.setSignatureEntryValidator(signatureEntryValidator);
        DecoratedTimestampValidator timestampValidator = new DecoratedTimestampValidator(context.getTimestampValidator());
        timestampValidator.addReviewer(new QESBasicTimestampReviewer(severity));
        myContext.setTimestampValidator(timestampValidator);
        return myContext;
    }

    @Override
    public IValidationContext decorate(IValidationContext context, IArgs args) {
        if (CommonPKIProfile.get(args) == CommonPKIProfile.QES_Basic) {
            return this.basicDecorate(context, args);
        }
        return context;
    }
}

