/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.app.validation.ICertificateChecker;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.standard.validation.VSCertificate;
import java.util.Set;

public class CertificateAttributesChecker
implements ICertificateChecker {
    @Override
    public void checkCertificate(IX509Certificate certificate, IValidationParameters params, Set<String> unresolvedCriticalExtensions, VSCertificate state) {
        if (!(certificate instanceof IX509PublicKeyCertificate)) {
            return;
        }
        this.removeSupportedExtensions(certificate, unresolvedCriticalExtensions);
    }

    protected void removeSupportedExtensions(IX509Certificate certificate, Set<String> unresolvedCriticalExtensions) {
        IX509Attribute[] attrs = certificate.getX509Attributes();
        if (attrs == null) {
            return;
        }
        for (int i = 0; i < attrs.length; ++i) {
            IX509Attribute attribute = attrs[i];
            unresolvedCriticalExtensions.remove(attribute.getType());
        }
    }
}

