/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.common;

import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.SignatureEntryValidatorFactory;
import de.intarsys.security.app.validation.common.IStateCachingStrategy;
import de.intarsys.security.app.validation.common.StateCachingStrategy;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSQualification;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.functor.IArgs;
import java.util.List;

public abstract class ExtendedSignatureEntryValidator
implements ISignatureEntryValidator {
    private static final Object ATTR_ENTRY_STATE = new Object();
    private IArgs args;
    private IStateCachingStrategy stateCachingStrategy;

    protected ExtendedSignatureEntryValidator(IArgs args) {
        this.args = args;
    }

    protected abstract void basicValidate(ISignatureEntry var1, VSSignatureEntry var2, IValidationParameters var3);

    public IArgs getArgs() {
        return this.args;
    }

    public IStateCachingStrategy getStateCachingStrategy() {
        if (this.stateCachingStrategy == null) {
            this.stateCachingStrategy = StateCachingStrategy.noCache();
        }
        return this.stateCachingStrategy;
    }

    public void setStateCachingStrategy(IStateCachingStrategy stateCachingStrategy) {
        this.stateCachingStrategy = stateCachingStrategy;
    }

    @Override
    public IVSSignatureEntry validate(ISignatureEntry entry, IDigest digest, IValidationParameters parameters) {
        ISignatureEntryValidator validator = SignatureEntryValidatorFactory.get().createValidator(entry, this.getArgs());
        IVSSignatureEntry basicEntryState = (IVSSignatureEntry)validator.validate(entry, digest, parameters);
        VSSignatureEntry result = new VSSignatureEntry(entry);
        result.setSignatureState(basicEntryState.getSignatureState());
        result.setModificationState(basicEntryState.getModificationState());
        IVSSignatureEntry previousState = (IVSSignatureEntry)this.getStateCachingStrategy().getCachedState(entry);
        if (previousState == null) {
            this.basicValidate(entry, result, parameters);
        } else {
            IVSQualification qState;
            List<IVSTimestamp> tsStates;
            List<IVSCertificate> attrCertStates;
            IVSCertificate certificateState = previousState.getCertificateState();
            if (certificateState != null) {
                result.setCertificateState(certificateState);
            }
            if ((attrCertStates = previousState.getAttributeCertificateStates()) != null) {
                result.setAttributeCertificateStates(attrCertStates);
            }
            if ((tsStates = previousState.getTimestampStates()) != null) {
                result.setTimestampStates(tsStates);
            }
            if ((qState = previousState.getQualificationState()) != null) {
                result.setQualificationState(qState);
            }
        }
        this.getStateCachingStrategy().cacheState(entry, result);
        return result;
    }
}

