/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.algorithm.ec.EcTools;
import de.intarsys.security.algorithm.ec.EcdsaTools;
import de.intarsys.security.algorithm.rsa.RsaTools;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PpkTools {
    private static final Logger Log = LoggerFactory.getLogger(PpkTools.class);

    public static int getExpectedSignatureSize(PublicKey pKey) {
        if (PpkTools.isSignatureAlgorithmRSA(pKey.getAlgorithm())) {
            return RsaTools.getExpectedSignatureSize(pKey);
        }
        return EcdsaTools.getExpectedSignatureSize(pKey) + 2;
    }

    public static int getKeyBitSize(PublicKey key) {
        String algo = key.getAlgorithm();
        if (PpkTools.isSignatureAlgorithmRSA(algo)) {
            return RsaTools.getKeyBitSize(key);
        }
        if (PpkTools.isSignatureAlgorithmECDSA(algo)) {
            return EcTools.getKeyBitSize(key);
        }
        return -1;
    }

    public static int getKeyByteSize(PublicKey publicKey) {
        return (PpkTools.getKeyBitSize(publicKey) + 7) / 8;
    }

    public static boolean isECKey(PublicKey key) {
        return key instanceof ECPublicKey;
    }

    public static boolean isRSAKey(PublicKey key) {
        return key instanceof RSAPublicKey;
    }

    public static boolean isSignatureAlgorithmECDSA(String algorithmName) {
        return "EC".equals(algorithmName) || "ECDSA".equals(algorithmName);
    }

    public static boolean isSignatureAlgorithmRSA(String algorithmName) {
        if ("RSA".equals(algorithmName)) {
            return true;
        }
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.lookupAlgorithmCanonical(algorithmName);
        if (signatureAlgorithm != null) {
            return signatureAlgorithm.getEncryptionAlgorithm().getName().equals("RSA");
        }
        return false;
    }

    public static boolean validate(byte[] signature, PublicKey key, AlgorithmParameterSpec params, byte[] message) {
        try {
            String algo = key.getAlgorithm();
            if (PpkTools.isSignatureAlgorithmRSA(algo)) {
                return RsaTools.validate(signature, key, params, message);
            }
            if (PpkTools.isSignatureAlgorithmECDSA(algo)) {
                return EcdsaTools.validate(signature, key, params, message);
            }
        }
        catch (Exception e) {
            Log.trace("Validation failed with message:" + e.getLocalizedMessage(), (Throwable)e);
        }
        return false;
    }
}

