/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.signature.AbstractSignatureContainer;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;

public abstract class CMSBasedSignatureContainer<T extends ISignatureContainerEntry>
extends AbstractSignatureContainer<T> {
    private ILocator locator;
    private ILocator signedContentLocator;

    protected static CMS createCMS(ASN1Encodable asn1Encodable) throws IOException {
        ASN1Sequence seq;
        ASN1Primitive asn1 = asn1Encodable.toASN1Primitive();
        if (asn1 instanceof ASN1Sequence && (seq = (ASN1Sequence)asn1).size() > 0) {
            ASN1Primitive obj1;
            ASN1Primitive obj0 = seq.getObjectAt(0).toASN1Primitive();
            if (obj0 instanceof ASN1ObjectIdentifier) {
                return (CMS)CMS.FACTORY.create(asn1Encodable);
            }
            if (obj0 instanceof ASN1Sequence && seq.size() > 1 && (obj1 = seq.getObjectAt(1).toASN1Primitive()) instanceof ASN1Sequence) {
                return (CMS)CMS.FACTORY.create((ASN1Encodable)obj1);
            }
        }
        throw new IllegalArgumentException("asn1Encodable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CMS createCMS(ILocator locator) throws IOException {
        InputStream in = null;
        try {
            in = locator.getInputStream();
            ASN1Primitive asn1Encodable = ASN1Tools.create((InputStream)in);
            CMS cMS = CMSBasedSignatureContainer.createCMS((ASN1Encodable)asn1Encodable);
            return cMS;
        }
        finally {
            StreamTools.close((Closeable)in);
        }
    }

    protected CMSBasedSignatureContainer(CMS cms) {
        super((Object)cms);
    }

    public byte[] getBytes() {
        try {
            return this.getCms().getDEREncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public CMS getCms() {
        return this.getImpl();
    }

    public CMS getImpl() {
        return (CMS)super.getImpl();
    }

    public ILocator getLocator() {
        if (this.locator == null) {
            this.locator = new ByteArrayLocator(this.getBytes(), "embedded", this.getTypedName());
        }
        return this.locator;
    }

    public ILocator getSignedContentLocator() {
        return this.signedContentLocator;
    }

    public int getSize() {
        return this.getEntries().size();
    }

    public String getTypedName() {
        if (this.locator != null) {
            return this.locator.getName();
        }
        return this.getTypedNameDefault();
    }

    protected String getTypedNameDefault() {
        return "default.cms";
    }

    public boolean isDetached() {
        return true;
    }

    public void setLocator(ILocator locator) {
        this.locator = locator;
    }

    public void setSignedContentLocator(ILocator signedDataReference) {
        this.signedContentLocator = signedDataReference;
    }
}

