/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.decoder;

import de.intarsys.asn1.cms.attr.AttributeRevocationValues;
import de.intarsys.asn1.cms.attr.RevocationValues;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.common.X509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPResponse;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.security.signature.attribute.IRevocationValuesAttribute;
import de.intarsys.security.signature.attribute.impl.RevocationValuesAttribute;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class RevocationValuesDecoder
implements IAttributeDecoder {
    public IRevocationValuesAttribute decodeAttribute(Object srcAttribute) throws IOException {
        Attribute cmsAttribute = (Attribute)srcAttribute;
        AttributeRevocationValues attrRev = (AttributeRevocationValues)AttributeRevocationValues.FACTORY.create((ASN1Encodable)cmsAttribute);
        if (attrRev == null || attrRev.getRevocationValues() == null) {
            return null;
        }
        RevocationValues values = attrRev.getRevocationValues();
        IX509CRL[] crls = this.getCRLs(values);
        IOCSPResponse[] ocsps = this.getOCSPs(values);
        return new RevocationValuesAttribute(crls, ocsps);
    }

    private IX509CRL[] getCRLs(RevocationValues values) throws IOException {
        ArrayList<X509CRL> result = new ArrayList<X509CRL>();
        for (CertificateList certList : values.getCRLs()) {
            try {
                result.add(new X509CRL(certList));
            }
            catch (CRLException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
        return result.toArray(new IX509CRL[result.size()]);
    }

    private IOCSPResponse[] getOCSPs(RevocationValues values) {
        ArrayList<OCSPResponse> result = new ArrayList<OCSPResponse>();
        for (BasicOCSPResponse basicOcsp : values.getOCSPs()) {
            result.add(new OCSPResponse(new BasicOCSPResp(basicOcsp)));
        }
        return result.toArray(new IOCSPResponse[result.size()]);
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.24";
    }
}

