/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.document.common.CommonDocumentType;
import de.intarsys.document.common.LocatorDocumentProxy;
import de.intarsys.document.common.PACKAGE;
import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.document.model.DocumentOutlet;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.content.IMimeTypeSupport;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locator.StringLocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.result.ILiteralResult;
import de.intarsys.tools.result.IResult;
import de.intarsys.tools.result.IStreamResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DocumentTools {
    public static final String ARG_DOCUMENTTAGDETECTOR = "documentTagDetector";
    public static final String ARG_DOCUMENT = "document";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static String[] AllFilterExtensions = new String[]{"*.*"};
    private static String[] AllFilterNames = new String[]{Msg.getString("DocumentTools.ExtensionAny", new Object[0])};
    private static final List<String> REGISTERED_EXTENSIONS = new ArrayList<String>();
    private static final List<String> REGISTERED_NAMES = new ArrayList<String>();
    private static final Attribute ATTR_MASTER = new Attribute("master");
    private static final Attribute ATTR_HASHCHECKED = new Attribute("hashChecked");
    private static final String MIME_TEXT_PLAIN = "text/plain";

    public static boolean acceptExtension(String extension) {
        return DocumentOutlet.get().lookupDocumentTypeForExtension(extension) != null;
    }

    public static IDocument asDocument(Object object) {
        if (object instanceof IDocument) {
            return (IDocument)object;
        }
        try {
            ILocator locator = DocumentTools.createLocator(object);
            if (locator != null) {
                return new LocatorDocumentProxy(locator);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void checkHash(IDocument idoc, Object hash, boolean force) throws IOException {
        Object tempValue = idoc.getAttribute(ATTR_HASHCHECKED);
        if (force || tempValue == null) {
            try {
                LocatorTools.checkHash((ILocator)idoc.getLocator(), (Object)hash);
                idoc.setAttribute(ATTR_HASHCHECKED, new Object());
            }
            catch (Exception e) {
                tempValue = e;
                idoc.setAttribute(ATTR_HASHCHECKED, e);
            }
        }
        if (tempValue instanceof IOException) {
            throw (IOException)tempValue;
        }
    }

    @Deprecated
    public static void checkHash(IDocument idoc, String algorithmName, Object hash, boolean force) throws IOException {
        DocumentTools.checkHash(idoc, hash, force);
    }

    public static IDocument createDocument(IArgs args, String name) throws IOException {
        Object docObject = ArgTools.getObject((IArgs)args, (String)name, null);
        IDocument idoc = DocumentTools.createDocument(docObject);
        if (idoc != null) {
            ArgTools.putPath((IArgs)args, (String)name, (Object)idoc);
        }
        return idoc;
    }

    public static IDocument createDocument(Object value) throws IOException {
        if (value instanceof IDocument) {
            ((IDocument)value).acquire();
            return (IDocument)value;
        }
        ILocator locator = DocumentTools.createLocator(value);
        if (locator != null) {
            Object args = locator instanceof IArgsSupport ? ((IArgsSupport)locator).getArgs() : Args.create();
            return DocumentTools.createFromLocator(locator, (IArgs)args);
        }
        return null;
    }

    public static IDocument createDocumentOrCurrent(IArgs args, String name) throws IOException {
        IDocument idoc = DocumentTools.createDocument(args, name);
        if (idoc == null && (idoc = DocumentEnvironment.get().getCurrentDocument()) != null) {
            idoc.acquire();
            ArgTools.putPath((IArgs)args, (String)name, (Object)idoc);
        }
        return idoc;
    }

    public static IDocument createFromImpl(String id, ILocator locator, Object impl) throws IOException {
        IDocumentType<?, ?> documentType = DocumentOutlet.get().lookupDocumentType(id);
        if (documentType != null) {
            return documentType.createFromImpl(locator, impl);
        }
        return null;
    }

    public static IDocument createFromLocator(ILocator locator, IArgs args) throws IOException {
        String contentType;
        IDocumentType documentType;
        if (locator == null) {
            return null;
        }
        if (locator instanceof IMimeTypeSupport && (documentType = DocumentTools.getDocumentTypeForMimeType(contentType = ((IMimeTypeSupport)locator).getContentType())) != null) {
            return documentType.createFromLocator(locator, args);
        }
        String extension = LocatorTools.getExtension((ILocator)locator);
        documentType = DocumentTools.getDocumentTypeForExtensionOrDefault(extension);
        if (documentType != null) {
            return documentType.createFromLocator(locator, args);
        }
        throw new IOException("document type for extension '" + extension + "' not supported");
    }

    public static IDocument createFromLocator(String id, ILocator locator, IArgs args) throws IOException {
        IDocumentType<?, ?> documentType = DocumentOutlet.get().lookupDocumentType(id);
        if (documentType != null) {
            return documentType.createFromLocator(locator, args);
        }
        throw new IOException("document type with id '" + id + "' not supported");
    }

    public static ILocator createLocator(Object value) throws IOException {
        return LocatorTools.createLocator((Object)value, (ILocatorFactory)DocumentEnvironment.get().getLocatorFactory(), null);
    }

    public static IDocument createNew(String id, IArgs args) throws IOException {
        IDocumentType<?, ?> documentType = DocumentOutlet.get().lookupDocumentType(id);
        if (documentType != null) {
            return documentType.createNew(args);
        }
        return null;
    }

    public static void detectTags(IDocument<?> document, IArgs tempArgs) throws Exception {
        InstanceSpec spec = InstanceSpec.get((IArgs)tempArgs, (String)ARG_DOCUMENTTAGDETECTOR, Object.class, null);
        if (spec != null) {
            InstanceSpec documentTagDetectorSpec = spec.copy();
            documentTagDetectorSpec.getArgs().put(ARG_DOCUMENT, document);
            FunctorTools.perform((InstanceSpec)documentTagDetectorSpec);
        }
    }

    public static String[] getAllFilterExtensions() {
        DocumentOutlet.get().getDocumentTypes();
        return AllFilterExtensions;
    }

    public static String[] getAllFilterNames() {
        DocumentOutlet.get().getDocumentTypes();
        return AllFilterNames;
    }

    public static IDocument getDocument(IArgs args, String name) throws IOException {
        Object docObject = ArgTools.getObject((IArgs)args, (String)name, null);
        IDocument idoc = DocumentTools.asDocument(docObject);
        if (idoc != null) {
            ArgTools.putPath((IArgs)args, (String)name, (Object)idoc);
        }
        return idoc;
    }

    public static IDocument getDocumentOrCurrent(IArgs args, String name) throws IOException {
        IDocument idoc = DocumentTools.getDocument(args, name);
        if (idoc == null) {
            idoc = DocumentEnvironment.get().getCurrentDocument();
        }
        return idoc;
    }

    public static IDocumentType getDocumentType(IArgs args, String name, IDocumentType defaultValue) {
        Object value = ArgTools.getObject((IArgs)args, (String)name, (Object)defaultValue);
        if (value instanceof IDocumentType) {
            return (IDocumentType)value;
        }
        if (value instanceof String) {
            return DocumentOutlet.get().lookupDocumentType((String)value);
        }
        return defaultValue;
    }

    public static IDocumentType getDocumentTypeForExtension(String extension) {
        return DocumentOutlet.get().lookupDocumentTypeForExtension(extension);
    }

    public static IDocumentType getDocumentTypeForExtensionOrDefault(String extension) {
        IDocumentType<?, ?> type = null;
        if (extension != null) {
            type = DocumentOutlet.get().lookupDocumentTypeForExtension(extension);
        }
        if (type == null) {
            type = DocumentEnvironment.get().getDefaultDocumentType();
        }
        return type;
    }

    public static IDocumentType getDocumentTypeForMimeType(String mimeType) {
        return DocumentOutlet.get().lookupDocumentTypeForMimeType(mimeType);
    }

    public static IDocumentType getDocumentTypeForMimeTypeOrDefault(String mimeType) {
        IDocumentType<?, ?> type = DocumentOutlet.get().lookupDocumentTypeForMimeType(mimeType);
        if (type == null) {
            type = DocumentEnvironment.get().getDefaultDocumentType();
        }
        return type;
    }

    public static String[] getFilterExtensions(IDocumentType type) {
        String[] extensions = type == null ? new String[]{} : DocumentOutlet.get().getExtensions(type);
        String[] filterExtensions = new String[extensions.length + 1];
        for (int i = 0; i < extensions.length; ++i) {
            String tempExtension = extensions[i];
            filterExtensions[i] = "*." + tempExtension;
        }
        filterExtensions[i] = "*.*";
        return filterExtensions;
    }

    public static String[] getFilterExtensionsCompressed(IDocumentType type) {
        return DocumentTools.getFilterExtensionsCompressed(new IDocumentType[]{type});
    }

    public static String[] getFilterExtensionsCompressed(IDocumentType[] types) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder allFilter = new StringBuilder();
        for (int iType = 0; iType < types.length; ++iType) {
            IDocumentType type = types[iType];
            String[] extensions = type == null ? new String[]{} : DocumentOutlet.get().getExtensions(type);
            StringBuilder filter = new StringBuilder();
            for (int i = 0; i < extensions.length; ++i) {
                filter.append("*.");
                filter.append(extensions[i]);
                if (i + 1 >= extensions.length) continue;
                filter.append(";");
            }
            result.add(filter.toString());
            allFilter.append((CharSequence)filter);
            if (iType >= types.length - 1) continue;
            allFilter.append(";");
        }
        if (types.length > 1) {
            result.add(0, allFilter.toString());
        }
        result.add("*.*");
        return result.toArray(new String[result.size()]);
    }

    public static String[] getFilterNames(IDocumentType type) {
        String[] names = type == null ? new String[]{} : DocumentOutlet.get().getExtensionNames(type);
        String[] filterNames = new String[names.length + 1];
        for (int i = 0; i < names.length; ++i) {
            String name;
            filterNames[i] = name = names[i];
        }
        filterNames[i] = Msg.getString("DocumentTools.ExtensionAny", new Object[0]);
        return filterNames;
    }

    public static String[] getFilterNamesCompressed(IDocumentType type) {
        return DocumentTools.getFilterNamesCompressed(new IDocumentType[]{type});
    }

    public static String[] getFilterNamesCompressed(IDocumentType[] types) {
        ArrayList<String> result = new ArrayList<String>();
        for (IDocumentType type : types) {
            String[] names = type == null ? new String[]{} : DocumentOutlet.get().getExtensionNames(type);
            StringBuilder allnames = new StringBuilder();
            for (int i = 0; i < names.length; ++i) {
                allnames.append(names[i]);
                if (i + 1 >= names.length) continue;
                allnames.append(", ");
            }
            result.add(allnames.toString());
        }
        if (types.length > 1) {
            result.add(0, Msg.getString("DocumentTools.ExtensionSupported", new Object[0]));
        }
        result.add(Msg.getString("DocumentTools.ExtensionAny", new Object[0]));
        return result.toArray(new String[result.size()]);
    }

    public static IDocument getMaster(IDocument idoc) {
        return (IDocument)idoc.getAttribute(ATTR_MASTER);
    }

    public static void registerExtension(CommonDocumentType.Extension extension) {
        DocumentTools.registerExtension(extension.getExtension(), extension.getLabel());
    }

    public static void registerExtension(String extension, String name) {
        String newFilterExtension = "*." + extension.toLowerCase();
        if (REGISTERED_EXTENSIONS.contains(newFilterExtension)) {
            return;
        }
        REGISTERED_EXTENSIONS.add(newFilterExtension);
        REGISTERED_NAMES.add(name);
        AllFilterExtensions = new String[REGISTERED_EXTENSIONS.size() + 2];
        AllFilterNames = new String[REGISTERED_EXTENSIONS.size() + 2];
        StringBuilder tempExtensions = new StringBuilder();
        int i = 1;
        Iterator<String> itExtensions = REGISTERED_EXTENSIONS.iterator();
        Iterator<String> itNames = REGISTERED_NAMES.iterator();
        while (itExtensions.hasNext()) {
            String tempExtension = itExtensions.next();
            String tempName = itNames.next();
            DocumentTools.AllFilterExtensions[i] = tempExtension;
            DocumentTools.AllFilterNames[i] = tempName;
            if (tempExtensions.length() == 0) {
                tempExtensions.append(tempExtension);
            } else {
                tempExtensions.append(";");
                tempExtensions.append(tempExtension);
            }
            ++i;
        }
        DocumentTools.AllFilterExtensions[0] = tempExtensions.toString();
        DocumentTools.AllFilterNames[0] = Msg.getString("DocumentTools.ExtensionSupported", new Object[0]);
        DocumentTools.AllFilterExtensions[DocumentTools.AllFilterExtensions.length - 1] = "*.*";
        DocumentTools.AllFilterNames[DocumentTools.AllFilterExtensions.length - 1] = Msg.getString("DocumentTools.ExtensionAny", new Object[0]);
    }

    public static void setMaster(IDocument idoc, IDocument master) {
        idoc.setAttribute(ATTR_MASTER, master);
    }

    public static IDocument wrap(Object value, String name, String extension) throws IOException {
        IDocumentType documentType;
        String mimeType = MIME_TEXT_PLAIN;
        if (value instanceof IResult) {
            mimeType = ((IResult)value).getContentType();
        }
        if ((documentType = DocumentTools.getDocumentTypeForMimeType(mimeType)) == null) {
            return null;
        }
        IDocument<Object> idoc = null;
        if (value instanceof IStreamResult) {
            ILocator locator = ((IStreamResult)value).getLocator();
            if (name != null) {
                locator.rename(name + "." + extension);
            }
            idoc = documentType.createFromLocator(locator, (IArgs)Args.create());
        } else {
            if (value instanceof ILiteralResult) {
                value = ((ILiteralResult)value).getValue();
            }
            if (value instanceof IDocument) {
                idoc = (IDocument)value;
            } else if (value instanceof String) {
                StringLocator locator = new StringLocator((String)value, name, extension);
                idoc = documentType.createFromLocator((ILocator)locator, (IArgs)Args.create());
            } else {
                idoc = documentType.createFromImpl(null, value);
            }
        }
        return idoc;
    }

    private DocumentTools() {
    }
}

