/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.content.IMimeTypeSupport;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.MethodException;

public abstract class DocumentProxy
implements IDocument,
IAdapterSupport {
    private IDocument document;
    private final Object lock = new Object();

    protected DocumentProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire() {
        Object object = this.lock;
        synchronized (object) {
            if (this.document == null) {
                this.getRealized();
                return this;
            }
            return this.document.acquire();
        }
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        IDocument tempDoc = this.ensureDocument();
        tempDoc.addNotificationListener(type, listener);
    }

    @Override
    public void close() {
        this.release(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDocument ensureDocument() {
        Object object = this.lock;
        synchronized (object) {
            if (this.document == null) {
                throw new InvalidRequestException("must acquire document before use");
            }
            return this.document;
        }
    }

    public <T> T getAdapter(Class<T> clazz) {
        IDocument tempDoc = this.ensureDocument();
        if (clazz.isInstance(tempDoc) && clazz.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    public final Object getAttribute(Object key) {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.getAttribute(key);
    }

    public String getContentType() {
        IDocument tempDoc = this.ensureDocument();
        IMimeTypeSupport adapter = (IMimeTypeSupport)AdapterTools.getAdapter((Object)tempDoc, IMimeTypeSupport.class, null);
        if (adapter != null) {
            return adapter.getContentType();
        }
        return "application/octet-stream";
    }

    public Object getImpl() {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.getImpl();
    }

    public ILocator getLocator() {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.getLocator();
    }

    @Override
    public String getLongName() {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.getLongName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getRealized() {
        Object object = this.lock;
        synchronized (object) {
            if (this.document == null) {
                this.document = this.realize();
            }
        }
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReferenceCount() {
        Object object = this.lock;
        synchronized (object) {
            if (this.document == null) {
                return 0;
            }
            return this.document.getReferenceCount();
        }
    }

    @Override
    public String getShortName() {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.getShortName();
    }

    @Override
    public IDocumentType getType() {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.getType();
    }

    public Object invoke(String name, IArgs args) throws MethodException {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.invoke(name, args);
    }

    @Override
    public boolean isChanged() {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.isChanged();
    }

    protected abstract IDocument realize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Object handle) {
        Object object = this.lock;
        synchronized (object) {
            if (this.document == null) {
                throw new InvalidRequestException("must acquire document before use");
            }
            if (this.document.release(handle)) {
                this.document = null;
                return true;
            }
            return false;
        }
    }

    public final Object removeAttribute(Object key) {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.removeAttribute(key);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        IDocument tempDoc = this.ensureDocument();
        tempDoc.removeNotificationListener(type, listener);
    }

    public final Object setAttribute(Object key, Object o) {
        IDocument tempDoc = this.ensureDocument();
        return tempDoc.setAttribute(key, o);
    }
}

