/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jaxrs.exception;

import de.intarsys.tools.exception.ErrorObject;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.jaxrs.exception.DtoError;
import de.intarsys.tools.jaxrs.exception.ResponseError;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    private static final Logger Log = LoggerFactory.getLogger(CommonExceptionMapper.class);

    protected Response basicToResponse(E exception) {
        return this.createResponse(this.toErrorObject(exception));
    }

    protected Response createResponse(ErrorObject errorObject) {
        ResponseError response = new ResponseError();
        DtoError errorDetail = this.toErrorDetail(errorObject);
        response.setError(errorDetail);
        return Response.status((int)errorObject.getStatus()).type("application/json").entity((Object)response).build();
    }

    protected DtoError toErrorDetail(ErrorObject errorObject) {
        DtoError detail = new DtoError();
        detail.setCode(errorObject.getCode());
        detail.setMessage(errorObject.getMessage());
        return detail;
    }

    protected ErrorObject toErrorObject(E e) {
        return ErrorObject.create((Throwable)ExceptionTools.unwrap(e));
    }

    public final Response toResponse(E exception) {
        Log.warn(((Throwable)exception).getMessage(), exception);
        return this.basicToResponse(exception);
    }
}

