/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.timestamp;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.security.method.cms.signature.CMSSignatureContainer;
import de.intarsys.security.timestamp.ITimestampInfo;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.timestamp.common.TimestampInfo;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class TimestampToken
implements ITimestampToken {
    private ITimestampInfo timestampInfo;
    private CMSSignatureContainer signatureContainer;

    public static ITimestampToken create(CMS cms) {
        return new TimestampToken(cms);
    }

    public static ITimestampToken create(CMSSignature signature) {
        return new TimestampToken(signature);
    }

    protected TimestampToken(CMS cms) {
        this(new CMSSignatureContainer(cms));
    }

    protected TimestampToken(CMSSignature signature) {
        this(new CMSSignatureContainer(signature));
    }

    protected TimestampToken(CMSSignatureContainer container) {
        this.signatureContainer = container;
    }

    public byte[] getEncoded() throws IOException {
        return this.getSignatureContainer().getBytes();
    }

    public CMSSignatureContainer getSignatureContainer() {
        return this.signatureContainer;
    }

    public ITimestampInfo getTimestampInfo() throws IOException {
        if (this.timestampInfo == null) {
            try {
                this.timestampInfo = TimestampInfo.parse((byte[])this.signatureContainer.getSignedContent());
            }
            catch (GeneralSecurityException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.timestampInfo;
    }
}

