/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.encoder;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.attr.AttributeSignerAttributesV2;
import de.intarsys.asn1.cms.attr.CertifiedAttributesV2;
import de.intarsys.asn1.cms.attr.SignerAttributeV2;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.signature.common.ISignatureData;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.Collection;

public class SignerAttributesV2Encoder
implements IAttributeEncoder {
    private Collection<IX509AttributeCertificate> attributeCertificates;

    public SignerAttributesV2Encoder(Collection<IX509AttributeCertificate> attrCerts) {
        this.attributeCertificates = attrCerts;
    }

    @Override
    public Attribute getAttribute(ICMSSignatureContainerBuilder builder, CMS cms, SignerInfo signerInfo, ISignatureData signatureData) throws IOException {
        AttributeSignerAttributesV2 signerAttributes = (AttributeSignerAttributesV2)AttributeSignerAttributesV2.FACTORY.createNew();
        SignerAttributeV2 signerAttribute = (SignerAttributeV2)SignerAttributeV2.FACTORY.createNew();
        signerAttributes.setSignerAttribute(signerAttribute);
        if (!this.getAttributeCertificates().isEmpty()) {
            CertifiedAttributesV2 certifiedAttributes = (CertifiedAttributesV2)CertifiedAttributesV2.FACTORY.createNew();
            signerAttribute.setCertifiedAttributes(certifiedAttributes);
            for (IX509AttributeCertificate cert : this.getAttributeCertificates()) {
                if (cert == null) continue;
                try {
                    AttributeCertificate asn1Cert = (AttributeCertificate)ASN1BasedTools.create((ASN1Based.Factory)AttributeCertificate.FACTORY, (byte[])cert.getEncoded());
                    certifiedAttributes.addAttributeCertificate(asn1Cert);
                }
                catch (CertificateEncodingException e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        }
        return signerAttributes;
    }

    public Collection<IX509AttributeCertificate> getAttributeCertificates() {
        return this.attributeCertificates;
    }

    @Override
    public boolean isToBeSigned() {
        return true;
    }
}

