/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.bytes;

import de.intarsys.tools.crypto.api.IByteProvider;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PbkdByteProvider
implements IByteProvider {
    public static final int DEFAULT_ITERATIONS = 10000;
    public static final String PBKDF2_WITH_HMAC_SHA1 = "PBKDF2WithHmacSHA1";
    public static final int DEFAULT_KEY_SIZE = 16;
    private byte[] key;
    private byte[] currentSalt;
    private IByteProvider passwordProvider;
    private int iterations = 10000;
    private int keySize = 16;
    private IByteProvider saltProvider;

    @Override
    public byte[] getBytes() throws IOException {
        return (byte[])this.key.clone();
    }

    public byte[] getCurrentSalt() {
        return this.currentSalt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getKeySize() {
        return this.keySize;
    }

    protected char[] getPassword() throws IOException {
        return new String(this.getPasswordProvider().getBytes(), StandardCharsets.UTF_8).toCharArray();
    }

    public IByteProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    public IByteProvider getSaltProvider() {
        return this.saltProvider;
    }

    public int getSize() {
        return this.keySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        if (this.passwordProvider == null) {
            throw new IllegalArgumentException("passwordProvider required");
        }
        if (this.saltProvider == null) {
            throw new IllegalArgumentException("saltProvider required");
        }
        if (this.key != null) {
            throw new IllegalArgumentException("master key cannot be reinitialized");
        }
        try {
            this.currentSalt = this.getSaltProvider().getBytes();
            char[] password = this.getPassword();
            SecretKeyFactory pbKeyFactory = SecretKeyFactory.getInstance(PBKDF2_WITH_HMAC_SHA1);
            PBEKeySpec pbKeySpec = new PBEKeySpec(password, this.currentSalt, this.getIterations(), this.getKeySize() * 8);
            try {
                SecretKey pbSecret = pbKeyFactory.generateSecret(pbKeySpec);
                this.key = pbSecret.getEncoded();
            }
            finally {
                pbKeySpec.clearPassword();
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to initialize master key", e);
        }
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setKeySize(int keyLength) {
        this.keySize = keyLength;
    }

    public void setPasswordProvider(IByteProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    public void setSaltProvider(IByteProvider saltProvider) {
        this.saltProvider = saltProvider;
    }

    public void setSize(int keyLength) {
        this.keySize = keyLength;
    }
}

