/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.DefaultValidationTarget;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSQualification;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.string.PrettyPrinter;

public class VSTimestamp
extends CommonValidationState
implements IVSTimestamp {
    private IVSSignatureContainer signatureState;
    private IVSDigest digestState;
    private IVSQualification qualificationState;

    public VSTimestamp(ITimestampToken timestamp) {
        super(new DefaultValidationTarget(timestamp));
    }

    public VSTimestamp(ITimestampToken timestamp, int state) {
        super((IValidationTarget)new DefaultValidationTarget(timestamp), state);
    }

    public VSTimestamp(IVSTimestamp state) {
        super(state);
    }

    @Override
    protected void copy(IValidationState state) {
        super.copy(state);
        IVSTimestamp tsState = (IVSTimestamp)state;
        this.signatureState = tsState.getSignatureState();
        this.digestState = tsState.getDigestState();
        this.qualificationState = tsState.getQualificationState();
    }

    @Override
    public IVSDigest getDigestState() {
        if (this.digestState == null) {
            this.digestState = new VSDigest();
        }
        return this.digestState;
    }

    @Override
    public IVSQualification getQualificationState() {
        return this.qualificationState;
    }

    @Override
    public IVSSignatureContainer getSignatureState() {
        ITimestampToken timestamp;
        if (this.signatureState == null && (timestamp = this.getTimestamp()) != null) {
            this.signatureState = VSSignatureContainer.getSignatureContainerState(timestamp.getSignatureContainer());
        }
        return this.signatureState;
    }

    @Override
    public ITimestampToken getTimestamp() {
        return (ITimestampToken)this.getValidationTarget().getImpl();
    }

    @Override
    public boolean isRecoverable() {
        if (!this.isUnknown()) {
            return false;
        }
        if (!this.isRecoverable(this.getDigestState())) {
            return false;
        }
        if (!this.isRecoverable(this.getSignatureState())) {
            return false;
        }
        return this.isRecoverable(this.getQualificationState());
    }

    public void setDigestState(IVSDigest pDigestState) {
        this.digestState = pDigestState;
        this.increaseState(pDigestState);
    }

    public void setQualificationState(IVSQualification pQualificationState) {
        this.qualificationState = pQualificationState;
        this.increaseState(pQualificationState);
    }

    public void setSignatureState(IVSSignatureContainer pSignatureState) {
        this.signatureState = pSignatureState;
        this.increaseState(pSignatureState);
    }

    @Override
    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        printer.appendMember("digestState", (Object)this.getDigestState(), null);
        printer.appendMember("qualificationState", (Object)this.getQualificationState(), null);
        printer.appendMember("signatureState", (Object)this.getSignatureState(), null);
    }
}

