/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IVSMathematicalSignature;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.message.IMessage;

public class VSMathematicalSignature
extends CommonValidationState
implements IVSMathematicalSignature {
    private byte[] signature;
    private AlgorithmSpec signatureAlgorithmSpec;
    private AlgorithmSpec hashAlgorithmSpec;

    public static IVSMathematicalSignature createInvalid(IMessage message) {
        VSMathematicalSignature state = new VSMathematicalSignature(3);
        state.addMessage(ValidationMessage.createError(message));
        return state;
    }

    public static IVSMathematicalSignature createInvalid(IValidationMessage message) {
        VSMathematicalSignature state = new VSMathematicalSignature(3);
        state.addMessage(message);
        return state;
    }

    public static IVSMathematicalSignature createInvalid(String message) {
        VSMathematicalSignature state = new VSMathematicalSignature(3);
        state.addMessage(ValidationMessage.createError(message));
        return state;
    }

    public static IVSMathematicalSignature createUnknown(IMessage message) {
        VSMathematicalSignature state = new VSMathematicalSignature(2);
        state.addMessage(ValidationMessage.createError(message));
        return state;
    }

    public static IVSMathematicalSignature createUnknown(IValidationMessage message) {
        VSMathematicalSignature state = new VSMathematicalSignature(2);
        state.addMessage(message);
        return state;
    }

    public static IVSMathematicalSignature createUnknown(String message) {
        VSMathematicalSignature state = new VSMathematicalSignature(2);
        state.addMessage(ValidationMessage.createError(message));
        return state;
    }

    public static IVSMathematicalSignature createValid(IValidationMessage message) {
        VSMathematicalSignature state = new VSMathematicalSignature(0);
        state.addMessage(message);
        return state;
    }

    public VSMathematicalSignature() {
        super((IValidationTarget)null);
    }

    public VSMathematicalSignature(int state) {
        super(null, state);
    }

    public AlgorithmSpec getHashAlgorithmSpec() {
        return this.hashAlgorithmSpec;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    public AlgorithmSpec getSignatureAlgorithmSpec() {
        return this.signatureAlgorithmSpec;
    }

    @Override
    public void merge(IValidationState toMerge) {
        super.merge(toMerge);
        if (!(toMerge instanceof IVSMathematicalSignature)) {
            return;
        }
        IVSMathematicalSignature sigState = (IVSMathematicalSignature)toMerge;
        this.setSignatureAlgorithmSpec(sigState.getSignatureAlgorithmSpec());
        this.setHashAlgorithmSpec(sigState.getHashAlgorithmSpec());
        this.setSignature(sigState.getSignature());
    }

    public void setHashAlgorithmSpec(AlgorithmSpec hashAlgorithmSpec) {
        this.hashAlgorithmSpec = hashAlgorithmSpec;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public void setSignatureAlgorithmSpec(AlgorithmSpec signatureAlgorithmSpec) {
        this.signatureAlgorithmSpec = signatureAlgorithmSpec;
    }
}

