/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature;

import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.AlgorithmTools;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.EncodingAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.BasicSignatureContainerValidator;
import de.intarsys.security.app.validation.ISignatureContainerEntryDefaultStateFactory;
import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.common.TimestampEntryDefaultStateFactory;
import de.intarsys.security.app.validation.pkcs1.EncodedSignatureEntryValidator;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.signature.AbstractSignatureContainer;
import de.intarsys.security.signature.EncodedSignatureEntry;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.PSSParameterSpec;
import java.util.Collections;
import java.util.List;

public class EncodedSignature
extends AbstractSignatureContainer<EncodedSignatureEntry> {
    private final List<IX509PublicKeyCertificate> certificates;
    private final AlgorithmSpec<DigestAlgorithm> hashAlgorithmSpec;
    private final AlgorithmSpec<SignatureAlgorithm> signatureAlgorithmSpec;
    private final EncodedSignatureEntry entry;

    public static EncodedSignature create(byte[] signatureBytes, String sigAlgOID, byte[] sigAlgParams, IX509PublicKeyCertificate certificate) throws GeneralSecurityException {
        return EncodedSignature.create(signatureBytes, sigAlgOID, sigAlgParams, certificate, null);
    }

    public static EncodedSignature create(byte[] signatureBytes, String signatureAlgorithmOid, byte[] encodedSignatureParams, IX509PublicKeyCertificate certificate, String defaultDigestAlgorithmName) throws GeneralSecurityException {
        DigestAlgorithm digestAlgorithm;
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.lookupAlgorithmCanonical(signatureAlgorithmOid);
        if (signatureAlgorithm == null) {
            throw new NoSuchAlgorithmException("Unknown signature algorithm " + signatureAlgorithmOid);
        }
        PSSParameterSpec signatureParams = null;
        if (signatureAlgorithm.getEncodingAlgorithm() == EncodingAlgorithm.ALG_PSS) {
            PSSParameterSpec pssParams = AlgorithmTools.toAlgorithmParameterSpec(encodedSignatureParams, "PSS", PSSParameterSpec.class);
            if (pssParams == null) {
                throw new NoSuchAlgorithmException("RSASSA-PSS without algorithm parameters");
            }
            signatureParams = pssParams;
            digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical(pssParams.getDigestAlgorithm());
        } else {
            digestAlgorithm = SignatureAlgorithm.getHashAlgorithm(signatureAlgorithmOid);
        }
        if (digestAlgorithm == null && (digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical(defaultDigestAlgorithmName)) == null) {
            throw new NoSuchAlgorithmException("Digest algorithm for " + signatureAlgorithmOid + " is unknown");
        }
        return new EncodedSignature(signatureBytes, new AlgorithmSpec<SignatureAlgorithm>(signatureAlgorithm, signatureParams), new AlgorithmSpec<DigestAlgorithm>(digestAlgorithm), certificate);
    }

    public EncodedSignature(byte[] signature, AlgorithmSpec<SignatureAlgorithm> signatureAlgorithmSpec, AlgorithmSpec<DigestAlgorithm> digestAlgorithmSpec, IX509PublicKeyCertificate signerCertificate) {
        this(signature, signatureAlgorithmSpec, digestAlgorithmSpec, Collections.singletonList(signerCertificate));
    }

    public EncodedSignature(byte[] signature, AlgorithmSpec<SignatureAlgorithm> signatureAlgorithmSpec, AlgorithmSpec<DigestAlgorithm> digestAlgorithmSpec, List<IX509PublicKeyCertificate> certificates) {
        super(signature);
        if (certificates.isEmpty()) {
            throw new IllegalArgumentException("No certificate available");
        }
        this.signatureAlgorithmSpec = signatureAlgorithmSpec;
        this.hashAlgorithmSpec = digestAlgorithmSpec;
        this.certificates = certificates;
        this.entry = new EncodedSignatureEntry(this);
    }

    @Override
    protected ISignatureContainerValidator createSignatureContainerValidator() {
        return new BasicSignatureContainerValidator();
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == ISignatureEntryValidator.class) {
            return clazz.cast(new EncodedSignatureEntryValidator());
        }
        if (clazz == ISignatureContainerEntryDefaultStateFactory.class) {
            return clazz.cast(new TimestampEntryDefaultStateFactory());
        }
        return super.getAdapter(clazz);
    }

    public byte[] getBytes() {
        return (byte[])this.getImpl();
    }

    public List<IX509PublicKeyCertificate> getCertificates() {
        return this.certificates;
    }

    @Override
    public List<EncodedSignatureEntry> getEntries() {
        return Collections.singletonList(this.getEntry());
    }

    public EncodedSignatureEntry getEntry() {
        return this.entry;
    }

    public AlgorithmSpec<DigestAlgorithm> getHashAlgorithmSpec() {
        return this.hashAlgorithmSpec;
    }

    public ILocator getLocator() {
        return new ByteArrayLocator(this.getBytes(), this.getTypedName());
    }

    public AlgorithmSpec<SignatureAlgorithm> getSignatureAlgorithmSpec() {
        return this.signatureAlgorithmSpec;
    }

    public ILocator getSignedDocument() {
        return null;
    }

    public IX509PublicKeyCertificate getSignerCertificate() {
        return this.certificates.get(0);
    }

    public String getTypedName() {
        return "signature.p1s";
    }
}

