/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.oid;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;

public class OIDTools {
    public static String getECCurveName(String curveOID) {
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(curveOID);
        String name = null;
        name = X962NamedCurves.getName((ASN1ObjectIdentifier)oid);
        if (name == null) {
            name = SECNamedCurves.getName((ASN1ObjectIdentifier)oid);
        }
        if (name == null) {
            name = NISTNamedCurves.getName((ASN1ObjectIdentifier)oid);
        }
        if (name == null) {
            name = TeleTrusTNamedCurves.getName((ASN1ObjectIdentifier)oid);
        }
        return name;
    }

    public static String getECCurveOID(String curveName) {
        ASN1ObjectIdentifier oid = null;
        oid = X962NamedCurves.getOID((String)curveName);
        if (oid == null) {
            oid = SECNamedCurves.getOID((String)curveName);
        }
        if (oid == null) {
            oid = NISTNamedCurves.getOID((String)curveName);
        }
        if (oid == null) {
            oid = TeleTrusTNamedCurves.getOID((String)curveName);
        }
        if (oid == null) {
            return null;
        }
        return oid.getId();
    }

    public static String getMaskGenerationAlgorithmOID(String jcaName) {
        switch (jcaName.toLowerCase()) {
            case "mgf1": {
                return "1.2.840.113549.1.1.8";
            }
        }
        return null;
    }
}

