/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.encoding;

import de.intarsys.security.encoding.Dinsig9796Encoding;
import de.intarsys.security.encoding.IEncoding;
import de.intarsys.security.encoding.ISO9796p2s1Encoding;
import de.intarsys.security.encoding.NoopEncoding;
import de.intarsys.security.encoding.PKCS1Type1Encoding;
import de.intarsys.security.encoding.PKCS1Type2Encoding;
import de.intarsys.security.encoding.PSSEncoding;
import de.intarsys.security.encoding.WellKnownEncoding;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;

public class EncodingTools {
    public static IEncoding createEncoding(AlgorithmParameterSpec paramSpec) throws GeneralSecurityException {
        if (paramSpec == null) {
            return null;
        }
        if (paramSpec instanceof PSSParameterSpec) {
            return PSSEncoding.createFrom(paramSpec);
        }
        throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec " + paramSpec + " not supported");
    }

    public static IEncoding createEncoding(String encodingSchemeName) throws GeneralSecurityException {
        if ("PKCS1Type1".equals(encodingSchemeName)) {
            return new PKCS1Type1Encoding();
        }
        if ("PKCS1Type2".equals(encodingSchemeName)) {
            return new PKCS1Type2Encoding();
        }
        if ("ISO9796p2s1".equals(encodingSchemeName)) {
            return new ISO9796p2s1Encoding();
        }
        if ("Dinsig9796".equals(encodingSchemeName)) {
            return new Dinsig9796Encoding();
        }
        if ("WellKnown".equals(encodingSchemeName)) {
            return new WellKnownEncoding();
        }
        if ("Noop".equals(encodingSchemeName)) {
            return new NoopEncoding();
        }
        throw new InvalidAlgorithmParameterException("encoding scheme " + encodingSchemeName + " not supported");
    }

    public static IEncoding guessEncoding(byte[] encodedMessage) {
        int typIndex = 1;
        if (encodedMessage[0] != 0) {
            --typIndex;
        }
        if (encodedMessage[typIndex] == 1) {
            return new PKCS1Type1Encoding();
        }
        if (encodedMessage[typIndex] == 2) {
            return new PKCS1Type2Encoding();
        }
        if ((encodedMessage[encodedMessage.length - 1] & 0xFF) == 188) {
            if (encodedMessage[0] == 96) {
                return new Dinsig9796Encoding();
            }
            return new ISO9796p2s1Encoding();
        }
        return null;
    }
}

