/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter;

import de.intarsys.security.certificate.IServiceType;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import java.util.HashSet;
import java.util.Set;

public class SimpleServiceTypeSelector
implements IServiceTypeSelector {
    private final Set<IServiceType> serviceTypes = new HashSet<IServiceType>();

    public static IServiceTypeSelector create(IServiceType ... serviceTypes) {
        SimpleServiceTypeSelector selector = new SimpleServiceTypeSelector();
        for (IServiceType type : serviceTypes) {
            selector.getServiceTypes().add(type);
        }
        return selector;
    }

    protected SimpleServiceTypeSelector() {
    }

    @Override
    public Set<IServiceType> getServiceTypes() {
        return this.serviceTypes;
    }

    @Override
    public boolean isQualifiedOnly() {
        if (this.serviceTypes.isEmpty()) {
            return false;
        }
        for (IServiceType type : this.serviceTypes) {
            if (type.isQualified()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTrustedOnly() {
        if (this.serviceTypes.isEmpty()) {
            return false;
        }
        for (IServiceType type : this.serviceTypes) {
            if (type.isTrusted()) continue;
            return false;
        }
        return true;
    }
}

