/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.NoCertificateFilter;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class OrListCertificateFilter
implements IX509CertificateFilter,
IElementSerializable,
IElementConfigurable {
    private final List<IX509CertificateFilter> filters;

    public static IX509CertificateFilter or(IX509CertificateFilter a, IX509CertificateFilter b) {
        if (a == null || a instanceof NoCertificateFilter) {
            return b;
        }
        if (b == null || b instanceof NoCertificateFilter) {
            return a;
        }
        if (a instanceof OrListCertificateFilter) {
            if (b instanceof OrListCertificateFilter) {
                return new OrListCertificateFilter(((OrListCertificateFilter)a).filters, ((OrListCertificateFilter)b).filters);
            }
            OrListCertificateFilter result = new OrListCertificateFilter();
            result.addFilters(((OrListCertificateFilter)a).filters);
            result.addFilter(b);
            return result;
        }
        if (b instanceof OrListCertificateFilter) {
            OrListCertificateFilter result = new OrListCertificateFilter();
            result.addFilter(a);
            result.addFilters(((OrListCertificateFilter)b).filters);
            return result;
        }
        return new OrListCertificateFilter(a, b);
    }

    public static IX509CertificateFilter remove(IX509CertificateFilter a, int index) {
        if (a instanceof OrListCertificateFilter) {
            if (index < 0 || index >= ((OrListCertificateFilter)a).filters.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not valid");
            }
            List<IX509CertificateFilter> filters = ((OrListCertificateFilter)a).filters;
            filters.remove(index);
            if (filters.size() == 1) {
                return filters.get(0);
            }
            if (filters.size() == 0) {
                return new NoCertificateFilter();
            }
            return new OrListCertificateFilter(filters);
        }
        if (index == 0) {
            return new NoCertificateFilter();
        }
        throw new IndexOutOfBoundsException("index " + index + " not valid");
    }

    public OrListCertificateFilter() {
        this.filters = new ArrayList<IX509CertificateFilter>();
    }

    public OrListCertificateFilter(IX509CertificateFilter ... filters) {
        this.filters = new ArrayList<IX509CertificateFilter>(Arrays.asList(filters));
    }

    public OrListCertificateFilter(List<IX509CertificateFilter> ... filters) {
        this.filters = new ArrayList<IX509CertificateFilter>();
        for (List<IX509CertificateFilter> filterList : filters) {
            this.filters.addAll(filterList);
        }
    }

    @Override
    public boolean accept(IX509Certificate certificate) {
        for (IX509CertificateFilter filter : this.filters) {
            if (!filter.accept(certificate)) continue;
            return true;
        }
        return false;
    }

    public void addFilter(IX509CertificateFilter filter) {
        this.filters.add(filter);
    }

    public void addFilters(IX509CertificateFilter ... filters) {
        this.filters.addAll(Arrays.asList(filters));
    }

    public void addFilters(List<IX509CertificateFilter> filters) {
        this.filters.addAll(filters);
    }

    public void configure(IElement element) throws ConfigurationException {
        IElement elChild;
        Iterator itChildren;
        IElement elChildren = element.element("filters");
        if (elChildren != null) {
            itChildren = elChildren.elementIterator();
            while (itChildren.hasNext()) {
                elChild = (IElement)itChildren.next();
                this.configureFilter(elChild);
            }
        }
        itChildren = element.elementIterator("filter");
        while (itChildren.hasNext()) {
            elChild = (IElement)itChildren.next();
            this.configureFilter(elChild);
        }
    }

    protected void configureFilter(IElement elChild) throws ConfigurationException {
        try {
            IX509CertificateFilter tmpFilter = (IX509CertificateFilter)ElementTools.createObject((IElement)elChild, IX509CertificateFilter.class, null, (IArgs)Args.create());
            this.addFilter(tmpFilter);
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public List<IX509CertificateFilter> getFilters() {
        return new ArrayList<IX509CertificateFilter>(this.filters);
    }

    @Override
    public boolean isX509NonRepudiation() {
        for (IX509CertificateFilter filter : this.filters) {
            if (filter.isX509NonRepudiation()) continue;
            return false;
        }
        return true;
    }

    public void removeFilter(IX509CertificateFilter filter) {
        this.filters.remove(filter);
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
        ElementTools.putObject((IElement)element, (String)"filters", this.getFilters());
    }
}

