/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.creation;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.Version;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import de.intarsys.asn1.x509.Extension;
import de.intarsys.asn1.x509.Extensions;
import de.intarsys.asn1.x509.Name;
import de.intarsys.asn1.x509.TBSCertificate;
import de.intarsys.asn1.x509.Time;
import de.intarsys.asn1.x509.Validity;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certificate.creation.CertificateSignerException;
import de.intarsys.security.certificate.creation.ICertificateSigner;
import de.intarsys.security.extension.IX509Extension;
import de.intarsys.security.extension.common.X509ExtensionAuthorityKeyIdentifier;
import de.intarsys.security.extension.common.X509ExtensionSubjectKeyIdentifier;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;

public class X509PublicKeyCertifier {
    private Date validFrom;
    private Date validTo;
    private final List<IX509Extension> extensions = new ArrayList<IX509Extension>();
    private String digestAlgorithmName = "SHA-256";
    private ICertificateSigner signer;
    private PublicKey publicKey;
    private BigInteger serialNumber;
    private X500Principal subject;

    protected void addExtension(Extensions extensions, IX509Extension extension, PublicKey subjectPublicKey, PublicKey issuerPublicKey, X500Principal issuerIssuerName, BigInteger issuerSerial) throws IOException {
        if ("2.5.29.35".equals(extension.getOid())) {
            newExtension = new X509ExtensionAuthorityKeyIdentifier();
            ((X509ExtensionAuthorityKeyIdentifier)newExtension).setPublicKey(issuerPublicKey);
            ((X509ExtensionAuthorityKeyIdentifier)newExtension).setIssuerName(issuerIssuerName);
            ((X509ExtensionAuthorityKeyIdentifier)newExtension).setIssuerSerial(issuerSerial);
            newExtension.setCritical(extension.isCritical());
            extension = newExtension;
        } else if ("2.5.29.14".equals(extension.getOid())) {
            newExtension = new X509ExtensionSubjectKeyIdentifier(subjectPublicKey);
            newExtension.setCritical(extension.isCritical());
            extension = newExtension;
        }
        Extension ext = (Extension)Extension.FACTORY.createNew();
        ext.setCritical(extension.isCritical());
        ext.setId(extension.getOid());
        ext.setValue(extension.getValue());
        extensions.addExtension(ext);
    }

    public void addExtension(IX509Extension extension) {
        this.extensions.add(extension);
    }

    public IX509PublicKeyCertificate createCertificate() throws IOException, GeneralSecurityException, CertificateSignerException {
        IX509PublicKeyCertificate[] issuerChain;
        BigInteger serialNumber;
        X500Principal issuer = null;
        PublicKey issuerPublicKey = null;
        X500Principal issuerIssuerName = null;
        BigInteger issuerSerial = null;
        String tmpEncryptionAlg = this.getSigner().getEncryptionAlgorithmName();
        String tmpDigestAlg = this.getDigestAlgorithmName();
        String signatureAlgorithm = SignatureAlgorithm.createOID(tmpEncryptionAlg, tmpDigestAlg, null);
        Date tmpValidFrom = this.getValidFrom() == null ? DateEnvironment.get().now() : this.getValidFrom();
        Date tmpValidTo = this.getValidTo();
        if (tmpValidTo == null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(tmpValidFrom);
            ((Calendar)cal).add(1, 1);
            tmpValidTo = cal.getTime();
        }
        if ((serialNumber = this.getSerialNumber()) == null) {
            byte[] serialNumberBytes = new byte[8];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(new Date().getTime());
            random.nextBytes(serialNumberBytes);
            serialNumber = new BigInteger(serialNumberBytes).abs();
        }
        if ((issuerChain = this.getSigner().getCertificatePath()) == null || issuerChain.length == 0) {
            issuer = this.getSubject();
            issuerPublicKey = this.getPublicKey();
            issuerIssuerName = this.getSubject();
            issuerSerial = serialNumber;
        } else {
            IX509PublicKeyCertificate issuerCert = issuerChain[0];
            issuer = issuerCert.getSubjectX500Principal();
            issuerPublicKey = issuerCert.getPublicKey();
            issuerIssuerName = issuerCert.getIssuerX500Principal();
            issuerSerial = issuerCert.getSerialNumber();
        }
        TBSCertificate tbsCertificate = (TBSCertificate)TBSCertificate.FACTORY.create((ASN1Encodable)new DERSequence());
        tbsCertificate.setVersion(Version.create((int)2));
        tbsCertificate.setSubject((Name)ASN1BasedTools.create((ASN1Based.Factory)Name.FACTORY, (byte[])this.getSubject().getEncoded()));
        tbsCertificate.setIssuer((Name)ASN1BasedTools.create((ASN1Based.Factory)Name.FACTORY, (byte[])issuer.getEncoded()));
        tbsCertificate.setSerialNumber((CertificateSerialNumber)CertificateSerialNumber.FACTORY.create((ASN1Encodable)new ASN1Integer(serialNumber)));
        Validity validity = (Validity)Validity.FACTORY.create((ASN1Encodable)new DERSequence());
        validity.setNotBeforeTime(Time.create((Date)tmpValidFrom));
        validity.setNotAfterTime(Time.create((Date)tmpValidTo));
        tbsCertificate.setValidity(validity);
        tbsCertificate.setAlgorithmIdentifier(AlgorithmIdentifier.create((String)signatureAlgorithm));
        tbsCertificate.setSubjectPublicKeyInfo(this.publicKey.getEncoded());
        Extensions extensions = (Extensions)Extensions.FACTORY.createNew();
        for (IX509Extension ext : this.getExtensions()) {
            this.addExtension(extensions, ext, this.getPublicKey(), issuerPublicKey, issuerIssuerName, issuerSerial);
        }
        tbsCertificate.setExtensions(extensions);
        IDigester digester = DigestTools.createDigester((String)tmpDigestAlg);
        IDigest digest = digester.digest(tbsCertificate.getDEREncoded());
        byte[] data = digest.getEncoded();
        byte[] signature = this.getSigner().sign(data);
        Certificate certificate = (Certificate)Certificate.FACTORY.create((ASN1Encodable)new DERSequence());
        certificate.setTBSCertificate(tbsCertificate);
        certificate.setSignatureAlgorithm(AlgorithmIdentifier.create((String)signatureAlgorithm));
        certificate.setSignatureValue(signature);
        return X509CertificateFactory.get().createPublicKeyCertificate(certificate.getDEREncoded());
    }

    public String getDigestAlgorithmName() {
        return this.digestAlgorithmName;
    }

    public List<IX509Extension> getExtensions() {
        return new ArrayList<IX509Extension>(this.extensions);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public ICertificateSigner getSigner() {
        return this.signer;
    }

    public X500Principal getSubject() {
        return this.subject;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public void setDigestAlgorithmName(String digestAlgorithmName) {
        this.digestAlgorithmName = digestAlgorithmName;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setSigner(ICertificateSigner signer) {
        this.signer = signer;
    }

    public void setSubject(X500Principal subject) {
        this.subject = subject;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public void setValidTo(Date validTo) {
        this.validTo = validTo;
    }
}

