/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.common.PACKAGE;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.AliasMessage;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.notice.INoticesSupport;
import de.intarsys.tools.validation.CommonValidator;
import de.intarsys.tools.validation.ValidationResult;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatePeriodValidator
extends CommonValidator<IX509Certificate> {
    public static final String ACTION_ERROR = "error";
    public static final String ACTION_IGNORE = "ignore";
    public static final String ACTION_DEFAULT = "default";
    public static final String ACTION_WARNING = "warning";
    public static final String NAME_DAYS_LEFT = "daysleft";
    public static final String NAME_NOT_AFTER = "notafter";
    public static final String NAME_NOT_BEFORE = "notbefore";
    public static final String NAME_FAIL = "fail";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    private static final Logger Log = LoggerFactory.getLogger(CertificatePeriodValidator.class);
    public static final String EA_ACTION = "action";
    public static final String EA_ACTION_DEFAULT = "default";
    public static final String EA_DEBUG = "debug";
    public static final String EA_VALUE = "value";
    private boolean addSubjectLabel = true;
    private final Map<String, Check> checks = new HashMap<String, Check>();

    public CertificatePeriodValidator() {
        this.init();
    }

    protected void basicValidate(ValidationResult result, IX509Certificate target) {
        for (Check check : this.checks.values()) {
            result.addNotices((INoticesSupport)check.validate(target));
        }
    }

    public void configure(IElement configuration) {
        Iterator it = configuration.elementIterator();
        while (it.hasNext()) {
            IElement element = (IElement)it.next();
            String name = element.getName();
            String value = element.attributeValue(EA_VALUE, null);
            String action = element.attributeValue(EA_ACTION, "default");
            String debug = element.attributeValue(EA_DEBUG, null);
            this.setAction(name, value, action, debug);
        }
    }

    protected String getSubjectLabel(IX509Certificate certificate) {
        if (this.isAddSubjectLabel()) {
            return "'" + CertificateTools.getSubjectLabel(certificate) + "' ";
        }
        return "";
    }

    protected void init() {
        this.setAction(NAME_NOT_AFTER, 0, "default", null);
        this.setAction(NAME_NOT_BEFORE, 0, "default", null);
        this.setAction(NAME_DAYS_LEFT, 30, "default", null);
    }

    public boolean isAddSubjectLabel() {
        return this.addSubjectLabel;
    }

    public void setAction(String name, Object value, String action, String debug) {
        String canonicalName = name.replace("-", "").toLowerCase();
        Check check = null;
        switch (canonicalName) {
            case "daysleft": {
                check = new CheckDaysLeft(value, action, debug);
                break;
            }
            case "fail": {
                check = new CheckFail(value, action, debug);
                break;
            }
            case "notafter": {
                check = new CheckNotAfter(value, action, debug);
                break;
            }
            case "notbefore": {
                check = new CheckNotBefore(value, action, debug);
                break;
            }
        }
        this.checks.put(canonicalName, check);
    }

    public void setAddSubjectLabel(boolean addSubjectLabel) {
        this.addSubjectLabel = addSubjectLabel;
    }

    public void setError(String name, Object value) {
        this.setAction(name, value, ACTION_ERROR, null);
    }

    public void setExpirationWarningPeriod(int warningPeriod) {
        this.setWarning(NAME_DAYS_LEFT, warningPeriod);
    }

    public void setIgnore(String name, Object value) {
        this.setAction(name, value, ACTION_IGNORE, null);
    }

    public void setWarning(String name, Object value) {
        this.setAction(name, value, ACTION_WARNING, null);
    }

    abstract class Check
    extends CommonValidator<IX509Certificate> {
        String debug;
        Object value;
        String action;

        public Check(Object value, String action, String debug) {
            this.value = value;
            this.action = action == null ? "default" : action.toLowerCase();
            this.debug = debug;
        }

        protected int getSeverity() {
            switch (this.action) {
                case "default": {
                    return this.getSeverityDefault();
                }
                case "error": {
                    return 30;
                }
                case "ignore": {
                    return 10;
                }
                case "warning": {
                    return 20;
                }
            }
            return this.getSeverityDefault();
        }

        public int getSeverityDefault() {
            return 30;
        }
    }

    class CheckDaysLeft
    extends Check {
        public CheckDaysLeft(Object value, String action, String debug) {
            super(value == null ? Integer.valueOf(30) : value, action, debug);
        }

        protected void basicValidate(ValidationResult result, IX509Certificate target) {
            Date now = DateEnvironment.get().now();
            Date notAfter = target.getNotAfter();
            try {
                int tmpValue = (Integer)ConverterRegistry.get().convert(this.value, Integer.class);
                if (tmpValue > 0) {
                    long withinMillis = (long)tmpValue * 24L * 60L * 60L * 1000L;
                    Date tempDate = new Date(now.getTime() + withinMillis);
                    if (tempDate.after(notAfter) && (!now.after(notAfter) || "trigger".equals(this.debug))) {
                        IMessage msg = Msg.getMessage("CertificateValidator.CertificateWillExpire", new Object[]{CertificatePeriodValidator.this.getSubjectLabel(target), DATE_FORMAT.format(notAfter)});
                        String code = "certificate.willExpire";
                        result.addNotice(this.getSeverity(), true, (IMessage)new AliasMessage(code, msg, new Object[0]));
                    }
                }
            }
            catch (ConversionException e) {
                Log.warn("cannot convert 'daysLeft' = " + this.value + " to integer");
            }
        }

        @Override
        public int getSeverityDefault() {
            return 20;
        }
    }

    class CheckFail
    extends Check {
        public CheckFail(Object value, String action, String debug) {
            super(value, action, debug);
        }

        protected void basicValidate(ValidationResult result, IX509Certificate target) {
            IMessage msg = Msg.getMessage("CertificateValidator.Failed", new Object[]{CertificatePeriodValidator.this.getSubjectLabel(target)});
            String code = "certificate.invalid";
            result.addNotice(this.getSeverity(), true, (IMessage)new AliasMessage(code, msg, new Object[0]));
        }
    }

    class CheckNotAfter
    extends Check {
        public CheckNotAfter(Object value, String action, String debug) {
            super(value, action, debug);
        }

        protected void basicValidate(ValidationResult result, IX509Certificate target) {
            Date notAfter;
            Date now = DateEnvironment.get().now();
            if (now.after(notAfter = target.getNotAfter()) || "trigger".equals(this.debug)) {
                IMessage msg = Msg.getMessage("CertificateValidator.CertificateExpired", new Object[]{CertificatePeriodValidator.this.getSubjectLabel(target), DATE_FORMAT.format(notAfter)});
                String code = "certificate.expired";
                result.addNotice(this.getSeverity(), true, (IMessage)new AliasMessage(code, msg, new Object[0]));
            }
        }
    }

    class CheckNotBefore
    extends Check {
        public CheckNotBefore(Object value, String action, String debug) {
            super(value, action, debug);
        }

        protected void basicValidate(ValidationResult result, IX509Certificate target) {
            Date notBefore;
            Date now = DateEnvironment.get().now();
            if (now.before(notBefore = target.getNotBefore()) || "trigger".equals(this.debug)) {
                IMessage msg = Msg.getMessage("CertificateValidator.CertificateNotYetValid", new Object[]{CertificatePeriodValidator.this.getSubjectLabel(target), DATE_FORMAT.format(notBefore)});
                String code = "certificate.notYetValid";
                result.addNotice(this.getSeverity(), true, (IMessage)new AliasMessage(code, msg, new Object[0]));
            }
        }
    }
}

