/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation;

import de.intarsys.security.app.validation.ICertificatePathBuilder;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.AdditionalCertificateProvider;
import de.intarsys.security.certificate.provider.standard.TrustedCertificateProvider;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationTools {
    private static final Logger Log = LoggerFactory.getLogger(ValidationTools.class);

    public static IX509Certificate[] getCertificatePath(IX509Certificate certificate) {
        return ValidationTools.getCertificatePath(certificate, true);
    }

    public static IX509Certificate[] getCertificatePath(IX509Certificate certificate, boolean signerFirst) {
        return ValidationTools.getCertificatePath(certificate, signerFirst, AdditionalCertificateProvider.get());
    }

    public static IX509Certificate[] getCertificatePath(IX509Certificate certificate, boolean signerFirst, ICertificateProvider additionalCertificates) {
        try {
            Args args = Args.create();
            args.put("stopOnIntermediateTrustAnchor", (Object)false);
            args.put("checkCRL", (Object)false);
            args.put("checkOCSP", (Object)false);
            IValidationContext validationContext = ValidationEnvironment.get().getValidationContextFactory().createValidationContext((IArgs)args);
            ICertificatePathBuilder pathBuilder = validationContext.getCertificatePathBuilder();
            ValidationParameters parameters = new ValidationParameters();
            parameters.setAdditionalCerts(additionalCertificates);
            parameters.setTrustedCerts(TrustedCertificateProvider.get());
            IVSCertificatePath state = pathBuilder.buildCertificatePath(certificate, parameters);
            if (state == null || state.getCertPath() == null) {
                return new IX509Certificate[]{certificate};
            }
            List<IX509Certificate> result = state.getCertPath().getPath();
            if (signerFirst) {
                Collections.reverse(result);
            }
            return result.toArray(new IX509Certificate[result.size()]);
        }
        catch (Exception e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return new IX509Certificate[]{certificate};
        }
    }
}

