/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.PACKAGE;
import de.intarsys.pdf.design.widget.format.PatternFormat;
import de.intarsys.tools.message.IMessageBundle;

public class SpecialFormat
extends PatternFormat {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String TYPE = "special";
    public static String[] PATTERNS = new String[]{"zipcode", "zipcode+4", "phonenumber", "idcardnumber"};

    public SpecialFormat() {
    }

    public SpecialFormat(int index) {
        super(index);
    }

    public SpecialFormat(String pattern) {
        super(pattern);
    }

    @Override
    protected void generateScripts() {
        int index = this.getPatternIndex();
        if (index > -1) {
            this.generateScriptsIndex(index);
        } else {
            this.generateScriptsPattern(this.getPattern());
        }
    }

    protected void generateScriptsIndex(int index) {
        this.setFormatScript(this.createScript("AFSpecial_Format", index));
        this.setKeyStrokeScript(this.createScript("AFSpecial_Keystroke", index));
    }

    protected void generateScriptsPattern(String pattern) {
        this.setFormatScript("");
        this.setKeyStrokeScript(this.createScript("AFSpecial_KeystrokeEx", pattern));
    }

    @Override
    public String[] getBuiltInPatterns() {
        return PATTERNS;
    }

    @Override
    protected String getDefaultPattern() {
        return PATTERNS[0];
    }

    @Override
    protected String getPatternLabel(int index) {
        String pattern = PATTERNS[index];
        String key = "SpecialFormat.PatternLabel." + pattern;
        return Msg.getString(key, new Object[0]);
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

