/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.CustomCalculationRule;
import de.intarsys.pdf.design.widget.format.CustomFormat;
import de.intarsys.pdf.design.widget.format.CustomValidationRule;
import de.intarsys.pdf.design.widget.format.DateCalculationRule;
import de.intarsys.pdf.design.widget.format.DateFormat;
import de.intarsys.pdf.design.widget.format.FieldCalculationRule;
import de.intarsys.pdf.design.widget.format.FieldFormat;
import de.intarsys.pdf.design.widget.format.FieldValidationRule;
import de.intarsys.pdf.design.widget.format.NumberFormat;
import de.intarsys.pdf.design.widget.format.PercentFormat;
import de.intarsys.pdf.design.widget.format.SimpleCalculationRule;
import de.intarsys.pdf.design.widget.format.SpecialFormat;
import de.intarsys.pdf.design.widget.format.TimeFormat;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionParser {
    private static final Logger Log = LoggerFactory.getLogger(FunctionParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object parse(String source, Object parser) {
        Context cx = Context.enter();
        ScriptableObject rootScope = cx.initStandardObjects();
        NativeJavaObject scope = new NativeJavaObject((Scriptable)rootScope, parser, null){

            public void put(int index, Scriptable start, Object value) {
            }

            public void put(String name, Scriptable start, Object value) {
            }
        };
        Object result = null;
        try {
            result = cx.evaluateString((Scriptable)scope, source, "temp", 1, null);
            if (result instanceof Wrapper) {
                result = ((Wrapper)result).unwrap();
            }
        }
        catch (Exception e) {
            Log.debug(e.getMessage(), (Throwable)e);
        }
        finally {
            Context.exit();
        }
        return result;
    }

    public static FieldCalculationRule parseCalculationRule(String source) {
        Object result = FunctionParser.parse(source, new CalculationRuleParser());
        if (result instanceof FieldCalculationRule) {
            return (FieldCalculationRule)result;
        }
        return new CustomCalculationRule();
    }

    public static FieldFormat parseFormat(String source) {
        Object result = FunctionParser.parse(source, new FormatParser());
        if (result instanceof FieldFormat) {
            return (FieldFormat)result;
        }
        return new CustomFormat();
    }

    public static FieldFormat parseKeystroke(String source) {
        Object result = FunctionParser.parse(source, new KeystrokeParser());
        if (result instanceof FieldFormat) {
            return (FieldFormat)result;
        }
        return new CustomFormat();
    }

    public static FieldValidationRule parseValidationRule(String source) {
        Object result = FunctionParser.parse(source, new ValidationRuleParser());
        if (result instanceof FieldValidationRule) {
            return (FieldValidationRule)result;
        }
        return new CustomValidationRule();
    }

    protected FunctionParser() {
    }

    public static class CalculationRuleParser {
        public Object AFSimple_Calculate(String operator, NativeArray fields) {
            SimpleCalculationRule rule = new SimpleCalculationRule();
            rule.setOperator(operator);
            long count = fields.getLength();
            int i = 0;
            while ((long)i < count) {
                String name = (String)fields.get(i, (Scriptable)fields);
                rule.addField(name);
                ++i;
            }
            return rule;
        }

        public Object EXTDate(String dateType, String pattern) {
            DateCalculationRule rule = new DateCalculationRule();
            rule.setDateType(dateType);
            rule.setPattern(pattern);
            return rule;
        }
    }

    public static class FormatParser {
        public Object AFDate_Format(int index) {
            return new DateFormat(index);
        }

        public Object AFDate_FormatEx(String pattern) {
            return new DateFormat(pattern);
        }

        public Object AFNumber_Format(int decimals, int separator, int negativeFlags, Object dummy, String currencyTag, boolean leading) {
            return new NumberFormat(decimals, separator, negativeFlags, dummy, currencyTag, leading);
        }

        public Object AFPercent_Format(int decimals, int separator) {
            return new PercentFormat(decimals, separator);
        }

        public Object AFSpecial_Format(int index) {
            return new SpecialFormat(index);
        }

        public Object AFTime_Format(int index) {
            return new TimeFormat(index);
        }

        public Object AFTime_FormatEx(String pattern) {
            return new TimeFormat(pattern);
        }

        public Object EXTNumber_Format(int decimals, int separator, int negativeFlags, Object dummy, String currencyTag, boolean leading) {
            return new NumberFormat(decimals, separator, negativeFlags, dummy, currencyTag, leading);
        }

        public Object EXTPercent_Format(int decimals, int separator) {
            return new PercentFormat(decimals, separator);
        }
    }

    public static class KeystrokeParser {
        public Object AFDate_Keystroke(int index) {
            return new DateFormat(index);
        }

        public Object AFDate_KeystrokeEx(String pattern) {
            return new DateFormat(pattern);
        }

        public Object AFNumber_Keystroke(int decimals, int separator, int negativeFlags, Object dummy, String currencyTag, boolean leading) {
            return new NumberFormat(decimals, separator, negativeFlags, dummy, currencyTag, leading);
        }

        public Object AFPercent_Keystroke(int decimals, int separator) {
            return new PercentFormat(decimals, separator);
        }

        public Object AFSpecial_Keystroke(int index) {
            return new SpecialFormat(index);
        }

        public Object AFSpecial_KeystrokeEx(String pattern) {
            return new SpecialFormat(pattern);
        }

        public Object AFTime_Keystroke(String pattern) {
            return new TimeFormat(pattern);
        }

        public Object EXTNumber_Keystroke(int decimals, int separator, int negativeFlags, Object dummy, String currencyTag, boolean leading) {
            return new NumberFormat(decimals, separator, negativeFlags, dummy, currencyTag, leading);
        }

        public Object EXTPercent_Keystroke(int decimals, int separator) {
            return new PercentFormat(decimals, separator);
        }
    }

    public static class ValidationRuleParser {
    }
}

