/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.tools.kernel;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.tools.geometry.GeometryTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class PDFGeometryTools {
    protected static final double RADIANS_MIN_270 = Math.toRadians(-270.0);
    protected static final double RADIANS_MIN_180 = Math.toRadians(-180.0);
    protected static final double RADIANS_MIN_90 = Math.toRadians(-90.0);

    public static CDSRectangle applyMatrix(CDSMatrix matrix, CDSRectangle rect) {
        float[] vec = new float[]{rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getUpperRightX(), rect.getUpperRightY()};
        float[] tVec = matrix.transform(vec);
        return new CDSRectangle(tVec);
    }

    public static AffineTransform applyPageSpace(int rotate, Rectangle2D rect, AffineTransform transform) {
        if (rotate == 0) {
            transform.translate(-rect.getMinX(), -rect.getMinY());
        } else if (rotate == 90) {
            transform.translate(-rect.getMinY(), rect.getMaxX());
            transform.rotate(RADIANS_MIN_90);
        } else if (rotate == 180) {
            transform.translate(rect.getMaxX(), rect.getMaxY());
            transform.rotate(RADIANS_MIN_180);
        } else if (rotate == 270) {
            transform.translate(rect.getMaxY(), -rect.getMinX());
            transform.rotate(RADIANS_MIN_270);
        } else {
            transform.translate(-rect.getMinX(), -rect.getMinY());
        }
        return transform;
    }

    public static AffineTransform applyPageSpace(PDPage page, AffineTransform transform) {
        int rotate = page.getNormalizedRotate();
        Rectangle2D rect = page.getCropBox().toNormalizedRectangle();
        return PDFGeometryTools.applyPageSpace(rotate, rect, transform);
    }

    public static CDSRectangle applyPageSpace(PDPage page, CDSRectangle rect) {
        if (page.getNormalizedRotate() == 0) {
            return rect.copy();
        }
        float[] points = new float[]{rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getUpperRightX(), rect.getUpperRightY()};
        AffineTransform transform = PDFGeometryTools.createPageSpace(page);
        GeometryTools.transformRect((AffineTransform)transform, (float[])points);
        return new CDSRectangle(points);
    }

    @Deprecated
    public static void applyUSRtoDS(AffineTransform transform, PDPage page, Rectangle2D pagerect, double scale) {
        transform.scale(scale, -scale);
        int rotate = page.getNormalizedRotate();
        if (rotate == 0) {
            transform.translate(-pagerect.getMinX(), -pagerect.getMaxY());
        } else if (rotate == 90) {
            transform.rotate(Math.toRadians(-90.0));
            transform.translate(-pagerect.getMinX(), -pagerect.getMinY());
        } else if (rotate == 180) {
            transform.rotate(Math.toRadians(-180.0));
            transform.translate(-pagerect.getMaxX(), -pagerect.getMinY());
        } else if (rotate == 270) {
            transform.rotate(Math.toRadians(-270.0));
            transform.translate(-pagerect.getMaxX(), -pagerect.getMaxY());
        } else {
            transform.translate(-pagerect.getMinX(), -pagerect.getMaxY());
        }
    }

    public static AffineTransform createPageSpace(PDPage page) {
        return PDFGeometryTools.applyPageSpace(page, new AffineTransform());
    }

    public static int normalizeRotate(int rotation) {
        if ((rotation %= 360) > 0) {
            return rotation - rotation % 90;
        }
        if (rotation == 0) {
            return 0;
        }
        rotation = 360 + rotation;
        return rotation - rotation % 90;
    }

    private PDFGeometryTools() {
    }
}

