/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.StreamBasedCMap;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;

public class NamedCMap
extends StreamBasedCMap {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CMap loadCMap(COSName name) {
        ClassLoader loader = NamedCMap.class.getClassLoader();
        try (InputStream is = loader.getResourceAsStream("cmaps/" + name.stringValue() + ".cmap");){
            if (is == null) {
                CMap cMap = null;
                return cMap;
            }
            byte[] bytes = StreamTools.getBytes((InputStream)is);
            NamedCMap map = new NamedCMap(name);
            CSContent content = CSContent.createFromBytes(bytes);
            map.initializeFromContent(content);
            NamedCMap namedCMap = map;
            return namedCMap;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected NamedCMap(COSObject object) {
        super(object);
    }

    public static class MetaClass
    extends StreamBasedCMap.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }
    }
}

