/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.IFilter;
import java.io.IOException;

public abstract class Filter
implements IFilter {
    public static final COSName CN_Filter_A85 = COSName.constant("A85");
    public static final COSName CN_Filter_AHx = COSName.constant("AHx");
    public static final COSName CN_Filter_ASCII85Decode = COSName.constant("ASCII85Decode");
    public static final COSName CN_Filter_ASCIIHexDecode = COSName.constant("ASCIIHexDecode");
    public static final COSName CN_Filter_CCF = COSName.constant("CCF");
    public static final COSName CN_Filter_CCITTFaxDecode = COSName.constant("CCITTFaxDecode");
    public static final COSName CN_Filter_Crypt = COSName.constant("Crypt");
    public static final COSName CN_Filter_DCT = COSName.constant("DCT");
    public static final COSName CN_Filter_DCTDecode = COSName.constant("DCTDecode");
    public static final COSName CN_Filter_Fl = COSName.constant("Fl");
    public static final COSName CN_Filter_FlateDecode = COSName.constant("FlateDecode");
    public static final COSName CN_Filter_JBIG2Decode = COSName.constant("JBIG2Decode");
    public static final COSName CN_Filter_JPXDecode = COSName.constant("JPXDecode");
    public static final COSName CN_Filter_LZW = COSName.constant("LZW");
    public static final COSName CN_Filter_LZWDecode = COSName.constant("LZWDecode");
    public static final COSName CN_Filter_RL = COSName.constant("RL");
    public static final COSName CN_Filter_RunLengthDecode = COSName.constant("RunLengthDecode");
    private COSDictionary options;
    private COSStream stream;

    protected Filter(COSDictionary paramOptions) {
        this.options = paramOptions;
    }

    protected abstract byte[] decode(byte[] var1) throws IOException;

    @Override
    public byte[] decode(byte[] source, int offset, int length) throws IOException {
        if (offset != 0 || length != source.length) {
            int minLength = Math.min(length, source.length);
            byte[] temp = new byte[minLength];
            System.arraycopy(source, offset, temp, 0, minLength);
            return this.decode(temp);
        }
        return this.decode(source);
    }

    protected abstract byte[] encode(byte[] var1) throws IOException;

    @Override
    public byte[] encode(byte[] source, int offset, int length) throws IOException {
        if (offset != 0 || length != source.length) {
            byte[] temp = new byte[length];
            System.arraycopy(source, offset, temp, 0, length);
            return this.encode(temp);
        }
        return this.encode(source);
    }

    public COSObject getOption(COSName name) {
        if (this.getOptions() == null) {
            return COSNull.NULL;
        }
        return this.getOptions().get(name);
    }

    public COSDictionary getOptions() {
        return this.options;
    }

    @Override
    public COSStream getStream() {
        return this.stream;
    }

    @Override
    public void setStream(COSStream stream) {
        this.stream = stream;
    }
}

