/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSIntegerInt;
import de.intarsys.pdf.cos.COSIntegerLong;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;

public abstract class COSInteger
extends COSNumber {
    public static COSInteger create(byte[] bytes, int start, int length) {
        long result = 0L;
        int end = start + length;
        boolean negative = false;
        byte prefix = bytes[start];
        if (prefix == 43) {
            ++start;
        } else if (prefix == 45) {
            negative = true;
            ++start;
        }
        for (int i = start; i < end; ++i) {
            result = result * 10L + (long)bytes[i] - 48L;
        }
        if (negative) {
            result = -result;
        }
        if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
            return new COSIntegerLong(result);
        }
        return new COSIntegerInt((int)result);
    }

    public static COSInteger create(int value) {
        return new COSIntegerInt(value);
    }

    public static COSInteger create(long value) {
        return new COSIntegerLong(value);
    }

    public static COSInteger createStrict(byte[] bytes, int start, int length) {
        COSInteger result = COSInteger.create(bytes, start, length);
        if (result instanceof COSIntegerLong) {
            return null;
        }
        return result;
    }

    protected COSInteger() {
    }

    @Override
    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        return visitor.visitFromInteger(this);
    }

    @Override
    public COSInteger asInteger() {
        return this;
    }

    @Override
    protected String basicToString() {
        return String.valueOf(this.intValue());
    }

    public boolean equals(Object o) {
        if (!(o instanceof COSInteger)) {
            return false;
        }
        return this.longValue() == ((COSInteger)o).longValue();
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    public int hashCode() {
        return this.intValue();
    }

    public Object saveState() {
        COSInteger result = (COSInteger)this.copyBasic();
        result.container = this.container.saveStateContainer();
        return result;
    }
}

