/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSExceptionHandler;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class COSDocumentElement
implements ICOSExceptionHandler {
    protected COSDocumentElement() {
    }

    public abstract Object accept(ICOSObjectVisitor var1) throws COSVisitorException;

    protected abstract ICOSContainer addContainer(ICOSContainer var1);

    public abstract COSDocumentElement containable();

    protected abstract COSObject copyDeep(Map var1);

    protected abstract COSDocumentElement copyShallowNested();

    public abstract COSObject dereference();

    protected boolean equalsGraph(Object o, PairRegister visited) {
        return this.equals(o);
    }

    public abstract COSDocument getDoc();

    @Override
    public void handleException(COSRuntimeException ex) throws COSRuntimeException {
        COSDocument doc = this.getDoc();
        if (doc == null) {
            throw ex;
        }
        doc.handleException(ex);
    }

    public boolean isReference() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public boolean isSwapped() {
        return false;
    }

    protected abstract void registerWith(COSDocument var1);

    protected abstract ICOSContainer removeContainer(ICOSContainer var1);

    protected static class PairRegister {
        private Map<COSObject, Set<COSObject>> register = new IdentityHashMap<COSObject, Set<COSObject>>();

        private void add(COSObject a, COSObject b) {
            Set<COSObject> set = this.register.get(a);
            if (set == null) {
                set = this.newSet();
                this.register.put(a, set);
            }
            set.add(b);
        }

        public boolean check(COSObject a, COSObject b) {
            if (!a.isIndirect() || !b.isIndirect()) {
                return false;
            }
            if (this.contains(a, b) || this.contains(b, a)) {
                return true;
            }
            this.add(a, b);
            return false;
        }

        private boolean contains(COSObject a, COSObject b) {
            Set<COSObject> set = this.register.get(a);
            return set != null && set.contains(b);
        }

        private <E> Set<E> newSet() {
            return Collections.newSetFromMap(new IdentityHashMap());
        }
    }
}

