/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSInterpreterFrame;
import de.intarsys.pdf.content.CSNotSupported;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSWarning;
import de.intarsys.pdf.content.ICSExceptionHandler;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.tools.string.StringTools;
import java.util.Map;

public abstract class CSInterpreter
implements ICSInterpreter {
    protected static final int PageLevel = 0;
    protected static final int TextObject = 1;
    protected static final int ShadingObject = 2;
    protected static final int ExternalObject = 3;
    protected static final int InLineImageObject = 4;
    protected static final int ClippingObject = 5;
    protected static final int PathObject = 6;
    private Map options;
    private ICSExceptionHandler exceptionHandler;
    protected CSInterpreterFrame frame;
    private boolean interruptible;

    protected CSInterpreter(Map paramOptions) {
        this.options = paramOptions;
    }

    private boolean checkInterrupt() {
        return this.isInterruptible() && Thread.currentThread().isInterrupted();
    }

    protected CSInterpreterFrame createFrame() {
        return new CSInterpreterFrame();
    }

    protected void decCompatibilitySectionDepth() {
        --this.frame.compatibilitySectionDepth;
    }

    protected PDDocument getDoc() {
        if (this.frame.doc == null && this.getResources() != null) {
            this.frame.doc = this.getResources().getDoc();
        }
        return this.frame.doc;
    }

    @Override
    public ICSExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public Map getOptions() {
        return this.options;
    }

    protected PDResources getResources() {
        return this.frame.resources;
    }

    protected void handleError(CSError error) throws CSException {
        if (this.exceptionHandler == null) {
            throw error;
        }
        this.exceptionHandler.error(error);
    }

    protected void handleWarning(CSWarning warning) throws CSException {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.warning(warning);
        }
    }

    protected void incCompatibilitySectionDepth() {
        ++this.frame.compatibilitySectionDepth;
    }

    protected boolean isCompatibilitySection() {
        return this.frame.compatibilitySectionDepth > 0;
    }

    public boolean isInterruptible() {
        return this.interruptible;
    }

    protected void notSupported(CSOperation operation) throws CSException {
        if (this.isCompatibilitySection()) {
            return;
        }
        this.handleWarning(new CSNotSupported("operation " + StringTools.safeString((Object)operation) + " not supported"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CSContent pContent, PDResources pResources) throws CSException {
        if (pContent == null) {
            return;
        }
        CSInterpreterFrame oldFrame = this.frame;
        try {
            this.frame = this.createFrame();
            this.frame.resources = pResources;
            if (this.frame.resources == null && oldFrame != null) {
                this.frame.resources = oldFrame.resources;
            }
            if (this.frame.resources != null) {
                try {
                    this.frame.defaultCMYK = this.frame.resources.getColorSpaceResource(PDColorSpace.CN_CS_DefaultCMYK);
                }
                catch (Exception ex) {
                    this.getExceptionHandler().warning(new CSWarning(ex));
                }
                try {
                    this.frame.defaultRGB = this.frame.resources.getColorSpaceResource(PDColorSpace.CN_CS_DefaultRGB);
                }
                catch (Exception ex) {
                    this.getExceptionHandler().warning(new CSWarning(ex));
                }
                try {
                    this.frame.defaultGray = this.frame.resources.getColorSpaceResource(PDColorSpace.CN_CS_DefaultGray);
                }
                catch (Exception ex) {
                    this.getExceptionHandler().warning(new CSWarning(ex));
                }
            } else {
                this.frame.defaultCMYK = null;
                this.frame.defaultRGB = null;
                this.frame.defaultGray = null;
            }
            int len = pContent.size();
            for (int i = 0; i < len; ++i) {
                if (this.checkInterrupt()) {
                    break;
                }
                CSOperation operation = pContent.getOperation(i);
                try {
                    this.process(operation);
                    continue;
                }
                catch (CSError e) {
                    this.handleError(e);
                    continue;
                }
                catch (CSWarning w) {
                    this.handleWarning(w);
                    continue;
                }
                catch (RuntimeException e) {
                    this.handleError(new CSError("unexpected exception", e));
                }
            }
        }
        finally {
            this.frame = oldFrame;
        }
    }

    protected void process(CSOperation operation) throws CSException {
        byte[] token = operation.getOperatorToken();
        if (token == null) {
            this.notSupported(operation);
            return;
        }
        block0 : switch (token[0]) {
            case 113: {
                this.render_q(operation);
                break;
            }
            case 81: {
                this.render_Q(operation);
                break;
            }
            case 84: {
                switch (token[1]) {
                    case 106: {
                        this.render_Tj(operation);
                        break block0;
                    }
                    case 74: {
                        this.render_TJ(operation);
                        break block0;
                    }
                    case 102: {
                        this.render_Tf(operation);
                        break block0;
                    }
                    case 100: {
                        this.render_Td(operation);
                        break block0;
                    }
                    case 76: {
                        this.render_TL(operation);
                        break block0;
                    }
                    case 68: {
                        this.render_TD(operation);
                        break block0;
                    }
                    case 99: {
                        this.render_Tc(operation);
                        break block0;
                    }
                    case 109: {
                        this.render_Tm(operation);
                        break block0;
                    }
                    case 114: {
                        this.render_Tr(operation);
                        break block0;
                    }
                    case 115: {
                        this.render_Ts(operation);
                        break block0;
                    }
                    case 119: {
                        this.render_Tw(operation);
                        break block0;
                    }
                    case 122: {
                        this.render_Tz(operation);
                        break block0;
                    }
                    case 42: {
                        this.render_Tstar(operation);
                        break block0;
                    }
                }
                this.notSupported(operation);
                break;
            }
            case 110: {
                this.render_n(operation);
                break;
            }
            case 115: {
                if (token.length == 1) {
                    this.render_s(operation);
                    break;
                }
                switch (token[1]) {
                    case 99: {
                        if (token.length == 2) {
                            this.render_sc(operation);
                            break block0;
                        }
                        this.render_scn(operation);
                        break block0;
                    }
                    case 104: {
                        this.render_sh(operation);
                        break block0;
                    }
                }
                this.notSupported(operation);
                break;
            }
            case 103: {
                if (token.length == 1) {
                    this.render_g(operation);
                    break;
                }
                this.render_gs(operation);
                break;
            }
            case 114: {
                switch (token[1]) {
                    case 101: {
                        this.render_re(operation);
                        break block0;
                    }
                    case 103: {
                        this.render_rg(operation);
                        break block0;
                    }
                    case 105: {
                        this.render_ri(operation);
                        break block0;
                    }
                }
                this.notSupported(operation);
                break;
            }
            case 82: {
                this.render_RG(operation);
                break;
            }
            case 109: {
                this.render_m(operation);
                break;
            }
            case 108: {
                this.render_l(operation);
                break;
            }
            case 102: {
                if (token.length == 1) {
                    this.render_f(operation);
                    break;
                }
                this.render_fstar(operation);
                break;
            }
            case 66: {
                if (token.length == 1) {
                    this.render_B(operation);
                    break;
                }
                switch (token[1]) {
                    case 42: {
                        this.render_Bstar(operation);
                        break block0;
                    }
                    case 84: {
                        this.render_BT(operation);
                        break block0;
                    }
                    case 77: {
                        this.render_BMC(operation);
                        break block0;
                    }
                    case 68: {
                        this.render_BDC(operation);
                        break block0;
                    }
                    case 88: {
                        this.render_BX(operation);
                        break block0;
                    }
                }
                this.notSupported(operation);
                break;
            }
            case 98: {
                if (token.length == 1) {
                    this.render_b(operation);
                    break;
                }
                this.render_bstar(operation);
                break;
            }
            case 83: {
                if (token.length == 1) {
                    this.render_S(operation);
                    break;
                }
                if (token.length == 2) {
                    this.render_SC(operation);
                    break;
                }
                this.render_SCN(operation);
                break;
            }
            case 104: {
                this.render_h(operation);
                break;
            }
            case 87: {
                if (token.length == 1) {
                    this.render_W(operation);
                    break;
                }
                this.render_Wstar(operation);
                break;
            }
            case 99: {
                if (token.length == 1) {
                    this.render_c(operation);
                    break;
                }
                switch (token[1]) {
                    case 109: {
                        this.render_cm(operation);
                        break block0;
                    }
                    case 115: {
                        this.render_cs(operation);
                        break block0;
                    }
                }
                this.notSupported(operation);
                break;
            }
            case 69: {
                switch (token[1]) {
                    case 84: {
                        this.render_ET(operation);
                        break block0;
                    }
                    case 77: {
                        this.render_EMC(operation);
                        break block0;
                    }
                    case 73: {
                        this.render_EI(operation);
                        break block0;
                    }
                    case 88: {
                        this.render_EX(operation);
                        break block0;
                    }
                }
                this.notSupported(operation);
                break;
            }
            case 120: {
                switch (token[1]) {
                    case 106: {
                        this.render_Tj(operation);
                        break block0;
                    }
                    case 74: {
                        this.render_TJ(operation);
                        break block0;
                    }
                }
                this.notSupported(operation);
                break;
            }
            case 71: {
                this.render_G(operation);
                break;
            }
            case 39: {
                this.render_Quote(operation);
                break;
            }
            case 34: {
                this.render_DoubleQuote(operation);
                break;
            }
            case 67: {
                this.render_CS(operation);
                break;
            }
            case 100: {
                if (token.length == 1) {
                    this.render_d(operation);
                    break;
                }
                switch (token[1]) {
                    case 48: {
                        this.render_d0(operation);
                        break block0;
                    }
                    case 49: {
                        this.render_d1(operation);
                        break block0;
                    }
                }
                this.notSupported(operation);
                break;
            }
            case 68: {
                switch (token[1]) {
                    case 111: {
                        this.render_Do(operation);
                        break block0;
                    }
                    case 80: {
                        this.render_DP(operation);
                        break block0;
                    }
                }
                this.notSupported(operation);
                break;
            }
            case 70: {
                this.render_F(operation);
                break;
            }
            case 105: {
                this.render_i(operation);
                break;
            }
            case 106: {
                this.render_j(operation);
                break;
            }
            case 74: {
                this.render_J(operation);
                break;
            }
            case 75: {
                this.render_K(operation);
                break;
            }
            case 107: {
                this.render_k(operation);
                break;
            }
            case 77: {
                if (token.length == 1) {
                    this.render_M(operation);
                    break;
                }
                this.render_MP(operation);
                break;
            }
            case 118: {
                this.render_v(operation);
                break;
            }
            case 119: {
                this.render_w(operation);
                break;
            }
            case 121: {
                this.render_y(operation);
                break;
            }
            default: {
                this.notSupported(operation);
            }
        }
    }

    protected void render_b(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_B(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_BDC(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_BMC(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_bstar(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Bstar(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_BT(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_BX(CSOperation operation) throws CSException {
        this.incCompatibilitySectionDepth();
    }

    protected void render_c(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_cm(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_cs(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_CS(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_d(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_d0(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_d1(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Do(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_DoubleQuote(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_DP(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_EI(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_EMC(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_ET(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_EX(CSOperation operation) throws CSException {
        this.decCompatibilitySectionDepth();
    }

    protected void render_f(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_F(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_fstar(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_g(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_G(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_gs(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_h(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_i(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_j(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_J(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_k(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_K(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_l(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_m(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_M(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_MP(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_n(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_q(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Q(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Quote(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_re(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_rg(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_RG(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_ri(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_s(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_S(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_sc(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_SC(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_scn(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_SCN(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_sh(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Tc(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Td(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_TD(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Tf(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Tj(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_TJ(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_TL(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Tm(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Tr(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Ts(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Tstar(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Tw(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Tz(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_v(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_w(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_W(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_Wstar(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    protected void render_y(CSOperation operation) throws CSException {
        this.notSupported(operation);
    }

    @Override
    public void setExceptionHandler(ICSExceptionHandler errorHandler) {
        this.exceptionHandler = errorHandler;
    }

    public void setInterruptible(boolean interruptible) {
        this.interruptible = interruptible;
    }
}

