/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.container;

import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.container.InstrumentProvider;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.tools.cli.CLICommandline;
import de.intarsys.tools.component.ComponentInternalException;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.infoset.DocumentBuilder;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.servicelocator.ServiceLocator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaptzContainer
implements IStartStop,
IElementConfigurable {
    private static final Logger Log = LoggerFactory.getLogger(ClaptzContainer.class);
    private StandardInstrumentRegistry instrumentRegistry;
    private boolean started;
    private IElement configuration = new DocumentBuilder().getRootElement();
    private List<InstrumentProvider> instrumentProviders = new ArrayList<InstrumentProvider>();

    public ClaptzContainer() {
        this.init();
    }

    public void addInstrumentProvider(InstrumentProvider instrumentProvider) {
        this.instrumentProviders.add(instrumentProvider);
    }

    protected void basicStart() throws Exception {
        this.installInstruments();
        this.getInstrumentRegistryImpl().start();
    }

    protected void basicStop() {
        this.getInstrumentRegistryImpl().stop();
    }

    public void configure(IElement element) throws ConfigurationException {
        Log.trace("{} configuration: {}", this.getLogLabel(), (Object)element);
        this.configuration = element;
    }

    protected StandardInstrumentRegistry createInstrumentRegistry() {
        StandardInstrumentRegistry tmp = new StandardInstrumentRegistry();
        ServiceLocator.get().put(IInstrumentRegistry.class, (Object)tmp);
        return tmp;
    }

    public IElement getConfiguration() {
        return this.configuration;
    }

    public List<InstrumentProvider> getInstrumentProviders() {
        return this.instrumentProviders;
    }

    protected IInstrumentRegistry getInstrumentRegistry() {
        return this.instrumentRegistry;
    }

    protected StandardInstrumentRegistry getInstrumentRegistryImpl() {
        return this.instrumentRegistry;
    }

    protected Object getLogLabel() {
        return "claptz container";
    }

    protected void hookStartAfter() {
    }

    protected void hookStartBefore() throws Exception {
    }

    protected void hookStartFailed(Exception e) {
        Log.warn("{} start failed", this.getLogLabel(), (Object)e);
        throw new IllegalStateException(ExceptionTools.unwrap((Throwable)e));
    }

    private void init() {
        this.instrumentRegistry = this.createInstrumentRegistry();
    }

    protected void installInstruments() throws InstrumentRegistryException {
        for (InstrumentProvider provider : this.getInstrumentProviders()) {
            provider.configureElement(this.getConfiguration());
            provider.configureCLI(CLICommandline.get());
            provider.load(this.getInstrumentRegistryImpl());
        }
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public void ppDefine(String symbol) {
        this.getInstrumentRegistryImpl().ppDefine(symbol);
    }

    public void setInstrumentProviders(List<InstrumentProvider> instrumentProviders) {
        this.instrumentProviders = instrumentProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        ClaptzContainer claptzContainer = this;
        synchronized (claptzContainer) {
            if (this.isStarted()) {
                return;
            }
            try {
                Log.debug("{} start()", this.getLogLabel());
                this.hookStartBefore();
                this.basicStart();
                this.hookStartAfter();
                this.started = true;
                Log.debug("{} started", this.getLogLabel());
            }
            catch (Exception e) {
                this.hookStartFailed(e);
                throw new ComponentInternalException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Log.info("{} stop()", this.getLogLabel());
        ClaptzContainer claptzContainer = this;
        synchronized (claptzContainer) {
            if (!this.isStarted()) {
                return;
            }
            this.basicStop();
            this.started = false;
        }
    }

    public final boolean stopRequested(Set visited) {
        return true;
    }
}

