/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.audit.v2.table;

import de.intarsys.security.audit.v2.core.IAuditSignatureProvider;
import de.intarsys.security.audit.v2.table.TableProcessorAudit;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.table.ITableColumn;
import de.intarsys.tools.table.ITableProcessor;
import de.intarsys.tools.table.ITableRecord;
import de.intarsys.tools.table.ITableType;
import de.intarsys.tools.table.TableColumn;
import de.intarsys.tools.table.TableProcessingException;
import de.intarsys.tools.table.TableProcessor;
import de.intarsys.tools.table.TableProcessorLog;
import de.intarsys.tools.table.TableProcessorView;
import java.util.List;
import org.slf4j.LoggerFactory;

public class TableProcessorAuditLog<R>
extends TableProcessor<R> {
    protected static final String ATTR_LOGGER = "logger";
    private TableProcessorView<ITableRecord> tableProcessorView = new TableProcessorView();
    private TableProcessorAudit<ITableRecord> tableProcessorAudit = new TableProcessorAudit();
    private TableProcessorLog<ITableRecord> tableProcessorLog = new TableProcessorLog();
    private String logger = "audit.common";

    public TableProcessorAuditLog() {
        this.tableProcessorLog.setLog(LoggerFactory.getLogger((String)("audit." + this.getLogger())));
        this.tableProcessorAudit.setChainedProcessor((ITableProcessor)this.tableProcessorLog);
        this.tableProcessorView.setChainedProcessor(this.tableProcessorAudit);
    }

    public void addViewColumn(TableColumn column) {
        this.tableProcessorView.getViewType().addColumn((ITableColumn)column);
    }

    public void close() throws TableProcessingException {
        this.getTableProcessorView().close();
        super.close();
    }

    public void configure(IElement element) throws ConfigurationException {
        IElement elLog;
        IElement elAudit;
        super.configure(element);
        IElement elView = element.element("view");
        if (elView != null) {
            this.getTableProcessorView().configure(elView);
        }
        if ((elAudit = element.element("audit")) != null) {
            this.getTableProcessorAudit().configure(elAudit);
        }
        if ((elLog = element.element("log")) != null) {
            this.getTableProcessorLog().configure(elLog);
        }
    }

    public String getLogger() {
        return this.logger;
    }

    public IAuditSignatureProvider getSignatureProvider() {
        return this.getTableProcessorAudit().getSignatureProvider();
    }

    public TableProcessorAudit<ITableRecord> getTableProcessorAudit() {
        return this.tableProcessorAudit;
    }

    public TableProcessorLog<ITableRecord> getTableProcessorLog() {
        return this.tableProcessorLog;
    }

    public TableProcessorView<ITableRecord> getTableProcessorView() {
        return this.tableProcessorView;
    }

    public List<ITableColumn> getViewColumns() {
        return this.tableProcessorView.getViewType().getColumns();
    }

    public void open(ITableType type) throws TableProcessingException {
        super.open(type);
        this.getTableProcessorView().open(type);
    }

    public R process(ITableRecord item) throws TableProcessingException {
        ITableRecord tableRecord = (ITableRecord)this.getTableProcessorView().process(item);
        return (R)super.process(tableRecord);
    }

    public void removeViewColumn(TableColumn column) {
        this.tableProcessorView.getViewType().removeColumn(column);
    }

    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        IElement elView = element.newElementMapped("view");
        this.getTableProcessorView().serialize(elView);
        IElement elAudit = element.newElementMapped("audit");
        this.getTableProcessorAudit().serialize(elAudit);
        IElement elLog = element.newElementMapped("log");
        this.getTableProcessorLog().serialize(elLog);
    }

    public void setLogger(String loggerName) {
        this.logger = loggerName;
        this.getTableProcessorLog().setLog(LoggerFactory.getLogger((String)("audit." + this.getLogger())));
    }

    public void setSignatureProvider(IAuditSignatureProvider provider) {
        this.getTableProcessorAudit().setSignatureProvider(provider);
    }
}

