/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.document.common.DocumentProxy;
import de.intarsys.document.model.DocumentOutlet;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;

public class NewDocumentProxy
extends DocumentProxy {
    private IDocumentType documentType;
    private IArgs args = Args.create();

    public NewDocumentProxy(IDocumentType documentType) {
        this.documentType = documentType;
    }

    public NewDocumentProxy(IDocumentType documentType, IArgs args) {
        this.documentType = documentType;
        this.args = args;
    }

    public NewDocumentProxy(String id) {
        this.documentType = DocumentOutlet.get().lookupDocumentType(id);
    }

    public NewDocumentProxy(String id, IArgs args) {
        this.documentType = DocumentOutlet.get().lookupDocumentType(id);
        this.args = args;
    }

    @Override
    protected IDocument realize() {
        try {
            return this.documentType.createNew(this.args);
        }
        catch (Exception e) {
            throw new TunnelingException("can't realize new document", (Throwable)e);
        }
    }
}

