/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.document.common.DocumentProxy;
import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;

public class LocatorDocumentProxy
extends DocumentProxy {
    private IArgs args = Args.create();
    private IDocumentType defaultDocumentType;
    private IDocumentType documentType;
    private final ILocator locator;

    public LocatorDocumentProxy(ILocator locator) {
        this.locator = locator;
    }

    public IArgs getArgs() {
        return this.args;
    }

    public IDocumentType getDefaultDocumentType() {
        return this.defaultDocumentType;
    }

    public IDocumentType getDocumentType() {
        return this.documentType;
    }

    @Override
    public ILocator getLocator() {
        return this.locator;
    }

    @Override
    protected IDocument realize() {
        IDocumentType<?, ?> tempType = this.documentType;
        if (tempType == null) {
            tempType = DocumentTools.getDocumentTypeForExtension(LocatorTools.getExtension((ILocator)this.locator));
        }
        if (tempType == null) {
            tempType = this.defaultDocumentType;
        }
        if (tempType == null) {
            tempType = DocumentEnvironment.get().getDefaultDocumentType();
        }
        if (tempType == null) {
            throw new IllegalArgumentException("unknown document type for '" + this.locator.getPath() + "'");
        }
        try {
            return tempType.createFromLocator(this.locator, this.getArgs());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't realize '" + this.locator.getPath() + "'", e);
        }
    }

    public void setArgs(IArgs args) {
        this.args = args;
    }

    public void setDefaultDocumentType(IDocumentType defaultDocumentType) {
        this.defaultDocumentType = defaultDocumentType;
    }

    public void setDocumentType(IDocumentType documentType) {
        this.documentType = documentType;
    }
}

