/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.document.common.CommonDocument;
import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.CreatedEvent;
import de.intarsys.tools.event.DestroyedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.StringLocator;
import de.intarsys.tools.locator.TransientLocator;
import de.intarsys.tools.objectmodel.ObjectModelTools;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.NullPreferences;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.result.ILiteralResult;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tag.TagTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CommonDocumentType<D extends IDocument<M>, M>
implements IDocumentType<D, M>,
IPresentationSupport,
IElementConfigurable,
IPreferencesSupport {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private String id;
    private final EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private String preferencesName;
    private IPreferences preferences;
    private String defaultExtension;
    private String defaultMimeType;
    private boolean integrate = false;
    private final Map<ILocator, D> documents = new HashMap<ILocator, D>();
    private boolean documentIdentity = true;
    private INotificationListener listenDocumentDestroyed = new INotificationListener(){

        public void handleEvent(Event event) {
            CommonDocumentType.this.onDocumentDestroyed(event);
        }
    };
    private INotificationListener listenDocumentChanged = new INotificationListener(){

        public void handleEvent(Event event) {
            CommonDocumentType.this.onDocumentChanged(event);
        }
    };
    private final List<Extension> extensions = new ArrayList<Extension>();

    protected CommonDocumentType() {
        this.id = this.getClass().getName();
        this.setDocumentIdentity(DocumentEnvironment.get().isDocumentIdentity());
    }

    @Override
    public void addExtension(String definition) {
        String extensionValue;
        String[] split = definition.split("\\|");
        String extensionLabel = extensionValue = split[0].trim().toLowerCase();
        if (split.length > 1) {
            extensionLabel = split[1].trim();
        }
        Extension extension = new Extension(extensionValue, extensionLabel);
        this.extensions.add(extension);
        DocumentTools.registerExtension(extension);
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected void addTags(IDocument idoc, IArgs args) throws IOException {
        IArgs tags = ArgTools.getArgs((IArgs)args, (String)"tags", null);
        if (tags != null) {
            Map tagMap = ArgTools.toMapDeepFlat((IArgs)tags);
            for (Map.Entry entry : tagMap.entrySet()) {
                String value;
                String name = (String)entry.getKey();
                try {
                    value = (String)ConverterRegistry.get().convert(entry.getValue(), String.class);
                }
                catch (ConversionException e) {
                    value = String.valueOf(entry.getValue());
                }
                TagTools.addTag((Object)idoc, (String)name, (String)value);
            }
        }
    }

    protected abstract D basicCreateFromImpl(ILocator var1, Object var2) throws IOException;

    protected abstract D basicCreateFromLocator(ILocator var1, IArgs var2) throws IOException;

    protected abstract D basicCreateNew(IArgs var1) throws IOException;

    public void configure(IElement element) throws ConfigurationException {
        this.setId(element.attributeValue("id", this.getId()).trim());
        this.setPreferencesName(element.attributeValue("preferences", this.getPreferencesName()));
        this.setIntegrate(ElementTools.getBool((IElement)element, (String)"integrate", (boolean)this.isIntegrate()));
        TagTools.configureTags((Object)this, (IElement)element);
    }

    @Override
    public D createFromImpl(ILocator locator, Object object) throws IOException {
        D idoc = null;
        Object impl = object instanceof ILiteralResult ? ((ILiteralResult)object).getValue() : object;
        if (impl instanceof ILocatorSupport) {
            locator = ((ILocatorSupport)impl).getLocator();
        }
        if (locator != null) {
            idoc = this.lookupDocument(locator);
        }
        if (idoc == null) {
            idoc = this.basicCreateFromImpl(locator, impl);
            if (idoc == null && locator != null) {
                try {
                    idoc = this.basicCreateFromLocator(locator, (IArgs)Args.create());
                }
                catch (IOException e) {
                    return null;
                }
            }
            if (idoc == null) {
                return null;
            }
            this.documentCreated(idoc);
        } else {
            idoc.acquire();
        }
        return idoc;
    }

    @Override
    public D createFromLocator(ILocator locator, IArgs args) throws IOException {
        D idoc = this.lookupDocument(locator);
        if (idoc == null) {
            idoc = this.basicCreateFromLocator(locator, args);
            if (idoc == null) {
                return null;
            }
            this.addTags((IDocument)idoc, args);
            this.documentCreated(idoc);
        } else {
            idoc.acquire();
        }
        return idoc;
    }

    public D createFromLocator(Object oLocator, IArgs args) throws IOException {
        ILocator locator = DocumentTools.createLocator(oLocator);
        return this.createFromLocator(locator, args);
    }

    protected ILocator createLocator(Object impl) {
        String name = this.createName(impl);
        String type = this.createType(impl);
        Object locator = null;
        locator = impl instanceof String ? new StringLocator((String)impl, name, type) : (impl instanceof byte[] ? new ByteArrayLocator((byte[])impl, name, type) : new TransientLocator(name, type));
        return locator;
    }

    protected String createName(Object impl) {
        Object name = this.getBaseName(impl);
        int counter = COUNTER.incrementAndGet();
        if (counter > 1) {
            name = (String)name + " [" + counter + "]";
        }
        return name;
    }

    @Override
    public D createNew(IArgs args) throws IOException {
        D idoc;
        if (args == null) {
            args = Args.create();
        }
        if ((idoc = this.basicCreateNew(args)) == null) {
            return null;
        }
        this.addTags((IDocument)idoc, args);
        this.documentCreated(idoc);
        return idoc;
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        if (StringTools.isEmpty((String)name)) {
            return NullPreferences.ACTIVE;
        }
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    protected String createType(Object impl) {
        return this.getBaseType(impl);
    }

    protected void documentCreated(D idoc) {
        idoc.acquire();
        this.registerDocument(idoc);
        CreatedEvent event = new CreatedEvent((Object)this);
        event.setInstance(idoc);
        this.triggerEvent((Event)event);
    }

    protected abstract String getBaseName(Object var1);

    protected abstract String getBaseType(Object var1);

    protected abstract String getDefaultDefaultExtension();

    protected abstract String getDefaultDefaultMimeType();

    @Override
    public final String getDefaultExtension() {
        if (this.defaultExtension == null) {
            return this.getDefaultDefaultExtension();
        }
        return this.defaultExtension;
    }

    @Override
    public final String getDefaultMimeType() {
        if (this.defaultMimeType == null) {
            return this.getDefaultDefaultMimeType();
        }
        return this.defaultMimeType;
    }

    public String getDescription() {
        return this.getTip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D[] getDocuments() {
        Map<ILocator, D> map = this.documents;
        synchronized (map) {
            return this.documents.values().toArray(new IDocument[this.documents.size()]);
        }
    }

    public String getIconName() {
        return "document";
    }

    @Override
    public String getId() {
        return this.id;
    }

    public IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return this.preferencesName;
    }

    public String getTip() {
        return this.getLabel();
    }

    public Object invoke(String name, IArgs args) throws MethodException {
        IArgs localArgs = args.copy();
        localArgs.put("documentType", (Object)this.getId());
        return ObjectModelTools.invokeIntercept((Object)this, (INotificationListener)this.dispatcher, (String)name, (IArgs)localArgs);
    }

    protected boolean isDocumentIdentity() {
        return this.documentIdentity;
    }

    @Override
    public boolean isIntegrate() {
        return this.integrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D lookupDocument(ILocator locator) {
        if (!this.isDocumentIdentity()) {
            return null;
        }
        Map<ILocator, D> map = this.documents;
        synchronized (map) {
            return (D)((IDocument)this.documents.get(locator));
        }
    }

    protected void onDocumentChanged(Event event) {
        AttributeChangedEvent ace = (AttributeChangedEvent)event;
        if (ace.getAttribute() == CommonDocument.ATTR_LOCATOR) {
            IDocument document = (IDocument)event.getSource();
            this.replaceLocator(document, (ILocator)ace.getOldValue(), (ILocator)ace.getNewValue());
        }
    }

    protected void onDocumentDestroyed(Event event) {
        IDocument document = (IDocument)event.getSource();
        this.unregisterDocument(document);
    }

    protected void preferencesInit(IPreferences preferences) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDocument(D idoc) {
        if (!this.isDocumentIdentity()) {
            return;
        }
        if (idoc.getLocator() == null) {
            throw new IllegalArgumentException("document locator must not be null");
        }
        Map<ILocator, D> map = this.documents;
        synchronized (map) {
            this.documents.put(idoc.getLocator(), idoc);
            idoc.addNotificationListener(DestroyedEvent.ID, this.listenDocumentDestroyed);
            idoc.addNotificationListener(AttributeChangedEvent.ID, this.listenDocumentChanged);
        }
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceLocator(D document, ILocator oldValue, ILocator newValue) {
        if (!this.isDocumentIdentity()) {
            return;
        }
        Map<ILocator, D> map = this.documents;
        synchronized (map) {
            this.documents.remove(oldValue);
            this.documents.put(newValue, document);
        }
    }

    @Override
    public void setDefaultExtension(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    @Override
    public void setDefaultMimeType(String defaultMimetype) {
        this.defaultMimeType = defaultMimetype;
    }

    protected void setDocumentIdentity(boolean documentIdentity) {
        this.documentIdentity = documentIdentity;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public void setIntegrate(boolean integrate) {
        this.integrate = integrate;
    }

    protected void setPreferencesName(String preferencesName) {
        this.preferencesName = preferencesName;
    }

    public String toString() {
        return this.getLabel();
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterDocument(D document) {
        if (!this.isDocumentIdentity()) {
            return;
        }
        Map<ILocator, D> map = this.documents;
        synchronized (map) {
            document.removeNotificationListener(DestroyedEvent.ID, this.listenDocumentDestroyed);
            document.removeNotificationListener(AttributeChangedEvent.ID, this.listenDocumentChanged);
            this.documents.remove(document.getLocator());
        }
    }

    public static class Extension {
        private String extension;
        private String label;

        public Extension(String extension, String label) {
            this.extension = extension;
            this.label = label;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getLabel() {
            return this.label;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

