/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.content.IMimeTypeSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.DestroyedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locator.TransientLocator;
import de.intarsys.tools.locking.ILock;
import de.intarsys.tools.locking.ILockLevel;
import de.intarsys.tools.locking.ILockSupport;
import de.intarsys.tools.objectmodel.ObjectModelTools;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reporter.Reporter;

public abstract class CommonDocument<M>
implements IDocument<M>,
IMimeTypeSupport {
    public static final Object ATTR_ALL = new Object();
    public static final Object ATTR_CHANGED = new Object();
    public static final Object ATTR_LOCATOR = new Object();
    private final IAttributeSupport attributeSupport;
    private boolean changed = false;
    private boolean released = false;
    private boolean open = false;
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);
    protected M impl;
    private ILocator locator;
    private int referenceCount = 0;
    private IDocumentType type;
    private ILock lock;

    protected CommonDocument(IDocumentType pType, ILocator pLocator, M pImpl) {
        this.type = pType;
        this.locator = pLocator;
        this.impl = pImpl;
        this.attributeSupport = this.impl instanceof IAttributeSupport ? (IAttributeSupport)this.impl : new AttributeMap();
        this.changed = this.isChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquire() {
        CommonDocument commonDocument = this;
        synchronized (commonDocument) {
            if (this.released) {
                if (this.locator != null) {
                    throw new InvalidRequestException("document '" + this.locator.getPath() + "' already closed");
                }
                throw new InvalidRequestException("document '(no locator)' already closed");
            }
            if (this.referenceCount == 0) {
                this.open();
            }
            ++this.referenceCount;
        }
        return null;
    }

    protected void acquireFileLock() {
        ILockSupport lockSupport = (ILockSupport)AdapterTools.getAdapter((Object)this.getLocator(), ILockSupport.class, null);
        if (lockSupport != null) {
            try {
                this.lock = lockSupport.getLock();
                this.lock.acquire((Object)this, ILockLevel.SHARED);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected final void basicRelease() {
        this.released = true;
        this.releaseFileLock();
        this.closeImpl();
    }

    @Override
    public void close() {
        this.release(null);
    }

    protected void closeImpl() {
    }

    public final Object getAttribute(Object key) {
        return this.attributeSupport.getAttribute(key);
    }

    public String getContentType() {
        return this.getType().getDefaultMimeType();
    }

    public IDocument getDocument() {
        return this;
    }

    @Override
    public M getImpl() {
        return this.impl;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    @Override
    public String getLongName() {
        return this.locator.getPath();
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    @Override
    public String getShortName() {
        return LocatorTools.getBaseName((ILocator)this.locator);
    }

    @Override
    public IDocumentType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String name, IArgs args) throws MethodException {
        Object referenceHandle = this.acquire();
        IArgs localArgs = args.copy();
        localArgs.put("document", (Object)this);
        try {
            Object object = ObjectModelTools.invokeIntercept((Object)this, (INotificationListener)this.dispatcher, (String)name, (IArgs)localArgs);
            return object;
        }
        finally {
            this.release(referenceHandle);
        }
    }

    @Override
    public boolean isChanged() {
        return this.changed || this.locator instanceof TransientLocator && !((TransientLocator)this.locator).isAlwaysUnchanged();
    }

    protected final void open() {
        this.open = true;
        this.released = false;
        this.acquireFileLock();
        this.openImpl();
    }

    protected void openImpl() {
    }

    public void print() {
        Args args = Args.create();
        try {
            this.invoke("print", (IArgs)args);
        }
        catch (MethodException e) {
            throw ExceptionTools.wrap((Throwable)ExceptionTools.unwrap((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Object handle) {
        CommonDocument commonDocument = this;
        synchronized (commonDocument) {
            if (this.released) {
                if (this.locator != null) {
                    throw new InvalidRequestException("document '" + this.locator.getPath() + "' already closed");
                }
                throw new InvalidRequestException("document '(no locator)' already closed");
            }
            --this.referenceCount;
            if (this.referenceCount > 0) {
                return false;
            }
            this.basicRelease();
        }
        DestroyedEvent event = new DestroyedEvent((Object)this);
        this.triggerEvent((Event)event);
        return true;
    }

    protected void releaseFileLock() {
        if (this.lock != null) {
            this.lock.release((Object)this);
        }
        this.lock = null;
    }

    public final Object removeAttribute(Object key) {
        Object value = this.attributeSupport.removeAttribute(key);
        if (value != null) {
            AttributeChangedEvent event = new AttributeChangedEvent((Object)this, key, value, null);
            this.triggerEvent((Event)event);
        }
        return value;
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public void save() {
        Args args = Args.create();
        try {
            this.invoke("save", (IArgs)args);
        }
        catch (MethodException e) {
            throw ExceptionTools.wrap((Throwable)ExceptionTools.unwrap((Throwable)e));
        }
    }

    public void save(Object newLocator) {
        Args args = Args.create();
        args.put("locator", newLocator);
        try {
            this.invoke("save", (IArgs)args);
        }
        catch (MethodException e) {
            throw ExceptionTools.wrap((Throwable)ExceptionTools.unwrap((Throwable)e));
        }
    }

    public final Object setAttribute(Object key, Object o) {
        Object oldValue = this.attributeSupport.setAttribute(key, o);
        boolean valueChanged = false;
        if (oldValue == null) {
            valueChanged = o != null;
        } else if (o == null) {
            valueChanged = true;
        } else {
            boolean bl = valueChanged = !oldValue.equals(o);
        }
        if (valueChanged) {
            AttributeChangedEvent event = new AttributeChangedEvent((Object)this, key, oldValue, o);
            this.triggerEvent((Event)event);
        }
        return oldValue;
    }

    protected void setChanged(boolean paramChanged) {
        if (paramChanged == this.changed) {
            return;
        }
        boolean oldChanged = this.changed;
        this.changed = paramChanged;
        this.triggerChangedChanged(oldChanged, paramChanged);
    }

    protected void setLocator(ILocator paramLocator) {
        if (paramLocator != null && paramLocator.equals(this.locator)) {
            return;
        }
        if (this.open) {
            this.releaseFileLock();
        }
        ILocator oldValue = this.locator;
        this.locator = paramLocator;
        if (this.open) {
            this.acquireFileLock();
        }
        this.triggerChangedLocator(oldValue, paramLocator);
    }

    protected void triggerChangedAll() {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, ATTR_ALL, null, null);
        this.triggerEvent((Event)event);
    }

    protected void triggerChangedChanged(Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, ATTR_CHANGED, oldValue, newValue);
        this.triggerEvent((Event)event);
    }

    protected void triggerChangedLocator(Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, ATTR_LOCATOR, oldValue, newValue);
        this.triggerEvent((Event)event);
    }

    protected void triggerEvent(Event event) {
        try {
            this.dispatcher.triggerEvent(event);
        }
        catch (RuntimeException e) {
            Reporter.get().reportError("Error", "Unexpected error", (Throwable)e, 0);
        }
    }

    public void view() {
        Args args = Args.create();
        try {
            this.invoke("view", (IArgs)args);
        }
        catch (MethodException e) {
            throw ExceptionTools.wrap((Throwable)ExceptionTools.unwrap((Throwable)e));
        }
    }
}

