/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.egov.validationclient.cli;

import de.intarsys.egov.validationclient.cli.OptionCertificate;
import de.intarsys.egov.validationclient.cli.OptionLang;
import de.intarsys.egov.validationclient.cli.OptionProxy;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import picocli.CommandLine;

@CommandLine.Command(name="validate", separator=" ")
public class CommandLineInterfaceClientOptions {
    private ConfigOptions configOptions;
    @CommandLine.Option(names={"-E", "--cert"}, converter={OptionCertificate.OptionCertificateConverter.class}, paramLabel="<certificate[:password]>", description={"File name and optional password to use for client certificate authentication. Supported file types are PKCS12 and JKS."})
    private OptionCertificate certificate;
    @CommandLine.Option(names={"-i", "--config"}, paramLabel="<filename>", description={"Name of configfile to use."})
    private String configIgnore;
    @CommandLine.Option(names={"-c", "--container-check"}, description={"Container check, validates all signatures in the pdf file. The option -c is mutually exclusive with -s when using -f. This option is not supported with -b."})
    private boolean containerCheck;
    @CommandLine.Option(names={"-d", "--dump"}, description={"Logs the JSON object of the request and response."})
    private boolean dump;
    @CommandLine.Option(names={"-l", "--lang"}, defaultValue="de", description={"get pdf report in the given language, supported codes: de, fr, it, en. This is an optional parameter, if omitted de is used."})
    private OptionLang lang;
    @CommandLine.Option(names={"-sun", "--serviceusername"}, description={"name of the user requesting the validation"})
    private String serviceUserName;
    @CommandLine.Option(names={"-suo", "--serviceuserorganization"}, description={"organization of the user requesting the validation"})
    private String serviceUserOrganization;
    @CommandLine.Option(names={"-list"}, description={"List digital signatures of given PDF file (is not supported with --batch-input-dir)."})
    private boolean list;
    @CommandLine.Option(names={"-m", "--mandator"}, description={"mandator to use, e.g. Qualified, FullQualified, Strafregisterauszug, or BAKOM (Can also be defined in config file)"})
    private String mandator;
    @CommandLine.Option(names={"-rs", "--outputstyle"}, paramLabel="<style>", description={"Defines the style of the generated pdf report, either a container with a report per signature or one report for all.The valid options are: -rs single or -rs container. The option can be omitted, default is single mode. This option is not supported with --batch-input-dir."})
    private String outputstyle;
    @CommandLine.Option(names={"-pw", "--password"}, description={"password for the basic authentication"})
    private String password;
    @CommandLine.Option(names={"-f", "--pdffile"}, paramLabel="<filename>", description={"File to validate. The option -f is mutually exclusive with -b."})
    private String pdffile;
    @CommandLine.Option(names={"-p", "--proxy"}, converter={OptionProxy.OptionProxyConverter.class}, paramLabel="<proxyhost:proxyport:proxyuser:proxypass>", description={"HTTP Proxy host and port to use for accessing the validation webservice. If not present, the Java System Properties are checked. For authentication use the format proxy:port:user:password"})
    private OptionProxy proxy;
    @CommandLine.Option(names={"-o", "--report"}, paramLabel="<filename>", description={"When -f is used, a PDF report will be saved at the given name.\nWhen -b is used, a batch report and a report for each file will be generated and packaged into a ZIP file.\nThe ZIP will be saved at the given name. The batch report will be named \"batch_report.pdf\"\nThe report for each file will be named after the validated document + \"_report.pdf\"\nExample:\n-o C:\\tmp\\example_report.zip\n-> C:\\tmp\\example_report.zip (contains batch_report.pdf and per-file reports)"})
    private String report;
    @CommandLine.Option(names={"-s", "--signature"}, paramLabel="<signaturename>", description={"Name of a signature to check in this pdf file (e.g. Signature1). Mutually exclusive with -c when using -f. This option is not supported with --batch-input-dir."})
    private String signature;
    @CommandLine.Option(names={"-e", "--unsigned"}, description={"Generate report even for unsigned files"})
    private boolean unsigned;
    @CommandLine.Option(names={"-u", "--url"}, description={"URL of the validation webservice. (Can also be defined in config file)"})
    private String url;
    @CommandLine.Option(names={"-un", "--username"}, description={"username for the basic authentication"})
    private String username;
    @CommandLine.Option(names={"-b", "--batch-input-dir"}, paramLabel="<dir>", description={"Path to the directory containing the files to be validated. The option -b is mutually exclusive with -f."})
    private String batchInputDir;

    public static CommandLineInterfaceClientOptions buildFromArgs(String[] args) {
        ConfigOptions configOptions = new ConfigOptions();
        CommandLine clConfig = new CommandLine((Object)configOptions);
        clConfig.setOverwrittenOptionsAllowed(true);
        clConfig.setUnmatchedArgumentsAllowed(true);
        clConfig.parseArgs(args);
        CommandLineInterfaceClientOptions options = new CommandLineInterfaceClientOptions();
        options.setConfigOptions(configOptions);
        CommandLine cl = new CommandLine((Object)options);
        cl.setOverwrittenOptionsAllowed(true);
        cl.parseArgs(args);
        options.validate(cl);
        return options;
    }

    public String getBatchInputDir() {
        return this.batchInputDir;
    }

    public OptionCertificate getCertificate() {
        return this.certificate;
    }

    public OptionLang getLang() {
        return this.lang;
    }

    public String getMandator() {
        String configMandator;
        if (this.configOptions != null && (configMandator = this.configOptions.getMandator()) != null) {
            return configMandator;
        }
        return this.mandator;
    }

    public String getOutputstyle() {
        return this.outputstyle;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPdffile() {
        return this.pdffile;
    }

    public OptionProxy getProxy() {
        OptionProxy configProxy;
        if (this.configOptions != null && (configProxy = this.configOptions.getProxy()) != null) {
            return configProxy;
        }
        return this.proxy;
    }

    public String getReport() {
        return this.report;
    }

    public String getServiceUserName() {
        return this.serviceUserName;
    }

    public String getServiceUserOrganization() {
        return this.serviceUserOrganization;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getUrl() {
        String configUrl;
        if (this.configOptions != null && (configUrl = this.configOptions.getValidatorUrl()) != null) {
            return configUrl;
        }
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isContainerCheck() {
        return this.containerCheck;
    }

    public boolean isDump() {
        return this.dump;
    }

    protected boolean isList() {
        return this.list;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    protected void setConfigOptions(ConfigOptions configOptions) {
        this.configOptions = configOptions;
    }

    private void validate(CommandLine cl) throws CommandLine.ParameterException {
        boolean hasOutputstyle;
        boolean hasBatch;
        CommandLine.Model.CommandSpec spec = cl.getCommandSpec();
        CommandLine.Model.OptionSpec optU = spec.findOption("-u");
        CommandLine.Model.OptionSpec optM = spec.findOption("-m");
        CommandLine.Model.OptionSpec optF = spec.findOption("-f");
        CommandLine.Model.OptionSpec optB = spec.findOption("-b");
        CommandLine.Model.OptionSpec optC = spec.findOption("-c");
        CommandLine.Model.OptionSpec optS = spec.findOption("-s");
        if (this.getUrl() == null) {
            throw new CommandLine.MissingParameterException(cl, List.of(optU), "Missing required option: '-u/--url'");
        }
        if (!this.isList() && this.getMandator() == null) {
            throw new CommandLine.MissingParameterException(cl, List.of(optM), "Missing required option: '-m/--mandator'");
        }
        if (this.isList()) {
            if (this.pdffile == null) {
                throw new CommandLine.MissingParameterException(cl, List.of(optF), "Option '-f/--pdffile' is required when using '-list'.");
            }
            if (this.batchInputDir != null) {
                throw new CommandLine.MutuallyExclusiveArgsException(cl, "Options '-list' and '-b/--batch-input-dir' are mutually exclusive.");
            }
            return;
        }
        boolean hasFile = this.pdffile != null;
        boolean bl = hasBatch = this.batchInputDir != null;
        if (hasFile && hasBatch) {
            throw new CommandLine.MutuallyExclusiveArgsException(cl, "Options '-f/--pdffile' and '-b/--batch-input-dir' are mutually exclusive.");
        }
        if (!hasFile && !hasBatch) {
            throw new CommandLine.MissingParameterException(cl, List.of(optF, optB), "Exactly one of '-f/--pdffile' or '-b/--batch-input-dir' must be provided.");
        }
        boolean hasC = this.containerCheck;
        boolean hasS = this.signature != null;
        boolean bl2 = hasOutputstyle = this.outputstyle != null;
        if (hasBatch) {
            if (hasC) {
                throw new CommandLine.ParameterException(cl, "Option '-c/--container-check' is not allowed when using '-b/--batch-input-dir'.");
            }
            if (hasS) {
                throw new CommandLine.ParameterException(cl, "Option '-s/--signature' is not allowed when using '-b/--batch-input-dir'.");
            }
            if (hasOutputstyle) {
                throw new CommandLine.ParameterException(cl, "Option '-rs/--outputstyle' is not allowed when using '-b/--batch-input-dir'.");
            }
        }
        if (hasFile) {
            if (hasC && hasS) {
                throw new CommandLine.MutuallyExclusiveArgsException(cl, "Options '-c/--container-check' and '-s/--signature' are mutually exclusive when using '-f/--pdffile'.");
            }
            if (!hasC && !hasS) {
                throw new CommandLine.MissingParameterException(cl, List.of(optC, optS), "Exactly one of '-c/--container-check' or '-s/--signature' must be provided when using '-f/--pdffile'.");
            }
        }
    }

    private static class ConfigOptions {
        private String mandator;
        private OptionProxy proxy;
        private String url;

        private ConfigOptions() {
        }

        public String getMandator() {
            return this.mandator;
        }

        public OptionProxy getProxy() {
            return this.proxy;
        }

        public String getValidatorUrl() {
            return this.url;
        }

        @CommandLine.Option(names={"-i", "--config"})
        private void setConfig(String filename) throws IOException {
            Properties config = new Properties();
            try (FileInputStream stream = new FileInputStream(filename);){
                config.load(stream);
            }
            this.mandator = config.getProperty("mandator");
            this.url = config.getProperty("validator_url");
            String proxyHost = config.getProperty("proxy_host");
            String proxyPort = config.getProperty("proxy_port");
            if (proxyHost != null && proxyPort != null) {
                this.proxy = new OptionProxy(proxyHost, Integer.parseInt(proxyPort));
            }
        }
    }
}

