/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.egov.validationclient.cli;

import ch.admin.suis.client.core.service.IValidationServiceClient;
import ch.admin.suis.client.core.service.ValidationServiceClientBuilder;
import ch.admin.suis.client.core.service.to.FileRequest;
import ch.admin.suis.validator.rest.to.response.FileReport;
import ch.admin.suis.validator.rest.to.response.ShortReport;
import ch.admin.suis.validator.rest.to.response.SignatureCoverageStatus;
import ch.admin.suis.validator.rest.to.response.SignatureReport;
import ch.admin.suis.validator.rest.to.response.ValidationResponse;
import de.intarsys.aaa.authenticate.impl.UserPasswordCredential;
import de.intarsys.egov.validationclient.cli.CommandLineInterfaceClientOptions;
import de.intarsys.egov.validationclient.cli.OptionCertificate;
import de.intarsys.egov.validationclient.cli.OptionProxy;
import de.intarsys.pdf.cds.CDSNameTreeNode;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDEmbeddedFile;
import de.intarsys.pdf.pd.PDFileSpecification;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.ssl.SslContextBuilder;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.logging.slf4j.SLF4JBridgeHandler;
import de.intarsys.tools.string.StringTools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class CommandLineInterfaceClient {
    private static final Logger Log = LoggerFactory.getLogger(CommandLineInterfaceClient.class);

    public static void main(String[] args) {
        CommandLineInterfaceClient cliClient = new CommandLineInterfaceClient();
        try {
            cliClient.run(args);
        }
        catch (ResponseException | CommandLine.ParameterException ex) {
            Log.error(ex.getMessage());
            System.exit(1);
        }
        catch (Exception ex) {
            Log.error("Unexpected exception", (Throwable)ex);
            System.exit(2);
        }
    }

    private void addZipEntry(ZipOutputStream zos, String entryName, byte[] content) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        zos.putNextEntry(entry);
        zos.write(content);
        zos.closeEntry();
    }

    protected IValidationServiceClient createClient(CommandLineInterfaceClientOptions options) throws IOException, NoSuchAlgorithmException {
        OptionProxy proxy;
        OptionCertificate certificate;
        ValidationServiceClientBuilder builder = ValidationServiceClientBuilder.newBuilder().serviceUrl(options.getUrl()).wireLogging(options.isDump());
        String username = options.getUsername();
        if (!StringTools.isEmpty((String)username)) {
            String password = options.getPassword();
            if (StringTools.isEmpty((String)password)) {
                builder.credential(new UserPasswordCredential(username, Secret.EMPTY));
            } else {
                builder.credential(new UserPasswordCredential(username, Secret.hide((char[])password.toCharArray())));
            }
        }
        if ((certificate = options.getCertificate()) != null) {
            try {
                KeyStore keyStore = null;
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(certificate.getFileName()));){
                    ((InputStream)stream).mark(4);
                    byte[] magic = new byte[4];
                    ((InputStream)stream).read(magic);
                    keyStore = magic[0] == 254 && magic[1] == 237 && magic[2] == 254 && magic[3] == 237 ? KeyStore.getInstance("JKS") : KeyStore.getInstance("PKCS12");
                    ((InputStream)stream).reset();
                    Secret password = certificate.getPassword();
                    keyStore.load(stream, password == null ? null : password.getChars());
                }
                SslContextBuilder sslContextBuilder = SslContextBuilder.create();
                sslContextBuilder.setKeyStore(keyStore);
                builder.sslContext(sslContextBuilder.createSslContext());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
        }
        if ((proxy = options.getProxy()) != null) {
            builder.proxyHost(proxy.getHost()).proxyPort(proxy.getPort()).proxyCredential(proxy.getCredential());
        }
        return builder.build();
    }

    protected List<PDFSignatureContainerEntry> extractContainerEntries(File pdfFile) throws IOException {
        PDFSignatureContainer container;
        try {
            container = PDFSignatureContainer.createSignatureContainer((PDDocument)PDDocument.createFromLocator((ILocator)new FileLocator(pdfFile)));
        }
        catch (COSLoadException ex) {
            throw new IOException(ex);
        }
        return container.getEntries();
    }

    protected void handleValidationResponse(ValidationResponse response) {
        if (response.getError() != null) {
            Log.error("Got error response: {}", (Object)response.getError());
            throw new ResponseException(response);
        }
        for (FileReport fileRep : response.getFileReports()) {
            Log.info("Name of validated document: {}", (Object)fileRep.getDocumentName());
            Log.info("Validity of file report: {}", (Object)fileRep.isValid());
            Log.info("was the document modified after last signature?: {}", (Object)fileRep.isDocModifiedAfterLastSignature());
            if (fileRep.isDocModifiedAfterLastSignature()) {
                Log.info("are the modifications acceptable (LTV, on whitelist)?: {}", (Object)(fileRep.getSignatureCoverageStatus() == SignatureCoverageStatus.MODIFIED_ACCEPTABLE ? 1 : 0));
            }
            Log.info("mandator requirements not met?: {}", (Object)fileRep.mandatorRequirementsNotMet());
            for (SignatureReport sigRep : fileRep.getSignatureReports()) {
                Log.info("results for signature with name: {}", (Object)sigRep.getSignatureName());
                for (ShortReport shortRep : sigRep.getReports()) {
                    Log.info("Name of check: {} status: {}", (Object)shortRep.getMessage(), (Object)shortRep.getValid());
                }
            }
        }
    }

    protected void run(CommandLineInterfaceClientOptions options) throws IOException, NoSuchAlgorithmException {
        if (options.isList()) {
            this.runList(options);
            return;
        }
        if (options.isContainerCheck()) {
            this.runContainerCheck(options);
            return;
        }
        if (options.getBatchInputDir() != null) {
            this.runBatch(options);
            return;
        }
        this.runSignature(options);
    }

    protected void run(String[] args) throws IOException, NoSuchAlgorithmException {
        try {
            CommandLineInterfaceClientOptions options = CommandLineInterfaceClientOptions.buildFromArgs(args);
            this.run(options);
        }
        catch (CommandLine.ParameterException ex) {
            ex.getCommandLine().usage(System.err);
            throw ex;
        }
    }

    protected void runContainerCheck(CommandLineInterfaceClientOptions options) throws IOException, NoSuchAlgorithmException {
        if ("container".equals(options.getOutputstyle())) {
            this.runContainerCheckSeparate(options);
            return;
        }
        this.runContainerCheckCombined(options);
    }

    protected void runContainerCheckCombined(CommandLineInterfaceClientOptions options) throws IOException, NoSuchAlgorithmException {
        File pdfFile = new File(options.getPdffile());
        FileRequest fileRequest = new FileRequest(pdfFile, options.getMandator());
        IValidationServiceClient client = this.createClient(options);
        ValidationResponse response = client.validateOneRequest(Collections.singletonList(fileRequest), !StringTools.isEmpty((String)options.getReport()), options.getServiceUserOrganization(), options.getServiceUserName(), options.getLang().name(), options.getReport(), options.isDump(), options.isUnsigned());
        this.handleValidationResponse(response);
        if (!StringTools.isEmpty((String)options.getReport())) {
            this.writeReport(response);
        }
    }

    protected void runContainerCheckSeparate(CommandLineInterfaceClientOptions options) throws IOException, NoSuchAlgorithmException {
        File pdfFile = new File(options.getPdffile());
        List<PDFSignatureContainerEntry> signatureEntries = this.extractContainerEntries(pdfFile);
        IValidationServiceClient client = this.createClient(options);
        ArrayList<ValidationResponse> responses = new ArrayList<ValidationResponse>(signatureEntries.size());
        for (PDFSignatureContainerEntry signatureEntry : signatureEntries) {
            String signatureName = signatureEntry.getPDSignature().getAcroFormField().getQualifiedName();
            responses.add(client.validateOneSignature(FileTools.getBytes((File)pdfFile), options.getMandator(), !StringTools.isEmpty((String)options.getReport()), signatureName, pdfFile.getName(), options.getServiceUserOrganization(), options.getServiceUserName(), options.getLang().name(), signatureName + ".pdf", options.isDump()));
        }
        for (ValidationResponse response : responses) {
            ResponseException exception;
            block5: {
                exception = null;
                try {
                    this.handleValidationResponse(response);
                }
                catch (ResponseException ex) {
                    if (exception != null) break block5;
                    exception = ex;
                }
            }
            if (exception == null) continue;
            throw exception;
        }
        if (!StringTools.isEmpty((String)options.getReport())) {
            this.writeReport(new File(options.getReport()), responses);
        }
    }

    protected void runList(CommandLineInterfaceClientOptions options) throws IOException {
        File pdfFile = new File(options.getPdffile());
        System.out.println(pdfFile.getName());
        List<PDFSignatureContainerEntry> signatureEntries = this.extractContainerEntries(pdfFile);
        signatureEntries.forEach(signatureEntry -> System.out.println("   " + signatureEntry.getPDSignature().getAcroFormField().getQualifiedName()));
    }

    protected void runSignature(CommandLineInterfaceClientOptions options) throws IOException, NoSuchAlgorithmException {
        File pdfFile = new File(options.getPdffile());
        IValidationServiceClient client = this.createClient(options);
        ValidationResponse response = client.validateOneSignature(FileTools.getBytes((File)pdfFile), options.getMandator(), !StringTools.isEmpty((String)options.getReport()), options.getSignature(), pdfFile.getName(), options.getServiceUserOrganization(), options.getServiceUserName(), options.getLang().name(), options.getReport(), options.isDump());
        this.handleValidationResponse(response);
        if (!StringTools.isEmpty((String)options.getReport())) {
            this.writeReport(response);
        }
    }

    protected void runBatch(CommandLineInterfaceClientOptions options) throws IOException, NoSuchAlgorithmException {
        List<Path> pdfPaths;
        Path inputDir = Paths.get(options.getBatchInputDir(), new String[0]);
        if (!Files.isDirectory(inputDir, new LinkOption[0])) {
            throw new IllegalArgumentException("argument --batch-input-dir is not a directory: " + inputDir.toAbsolutePath());
        }
        try (Stream<Path> stream = Files.list(inputDir);){
            pdfPaths = stream.filter(p -> p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".pdf")).toList();
        }
        if (pdfPaths.isEmpty()) {
            throw new IllegalArgumentException("No PDF files found in --batch-input-dir: " + inputDir.toAbsolutePath());
        }
        ArrayList<FileRequest> requests = new ArrayList<FileRequest>();
        String clientMandator = options.getMandator();
        for (Path p2 : pdfPaths) {
            requests.add(new FileRequest(p2.toFile(), clientMandator));
        }
        IValidationServiceClient client = this.createClient(options);
        ValidationResponse response = client.validateOneRequestZip(requests, options.getServiceUserOrganization(), options.getServiceUserName(), options.getLang().name(), options.getReport(), options.isDump(), options.isUnsigned());
        this.handleValidationResponse(response);
        if (!StringTools.isEmpty((String)options.getReport())) {
            this.writeBatchReport(response);
        }
    }

    protected void writeReport(File file, List<ValidationResponse> responses) throws IOException {
        PDDocument document = PDDocument.createNew();
        PDPage page = (PDPage)PDPage.META.createNew();
        document.addPageNode((PDPageNode)page);
        CSCreator creator = CSCreator.createNew((IContentStreamProvider)page);
        creator.saveState();
        creator.textBegin();
        creator.textLineMove(36.0f, 790.0f);
        creator.textSetFont(null, PDFontTools.createBuiltinFont((String)"Helvetica"), 12.0f);
        byte[] text = "PDF container, see attached files".getBytes();
        creator.textShow(text, 0, text.length);
        creator.textEnd();
        creator.restoreState();
        creator.close();
        COSDictionary namesDict = COSDictionary.create((int)1);
        CDSNameTreeNode embeddedFilesNode = CDSNameTreeNode.createRootLeaf();
        responses.forEach(response -> {
            PDFileSpecification fileSpec = (PDFileSpecification)PDFileSpecification.META.createNew();
            fileSpec.setFileSpecificationString(PDFileSpecification.DK_F, response.getPdfOutputFileName());
            fileSpec.setFileSpecificationString(PDFileSpecification.DK_UF, response.getPdfOutputFileName());
            PDEmbeddedFile embeddedFile = (PDEmbeddedFile)PDEmbeddedFile.META.createNew();
            embeddedFile.setBytes(response.getPdfReport());
            fileSpec.setEmbeddedFile(PDFileSpecification.DK_F, embeddedFile);
            fileSpec.setEmbeddedFile(PDFileSpecification.DK_UF, embeddedFile);
            embeddedFilesNode.put(COSString.create((String)response.getPdfOutputFileName()), fileSpec.cosGetObject());
        });
        namesDict.put(COSCatalog.DK_EmbeddedFiles, embeddedFilesNode.cosGetObject());
        document.getCatalog().cosSetNames(namesDict);
        document.save((ILocator)new FileLocator(file));
    }

    protected void writeBatchReport(ValidationResponse response) throws IOException {
        Object zipFileName = response.getPdfOutputFileName().endsWith(".zip") ? response.getPdfOutputFileName() : response.getPdfOutputFileName() + ".zip";
        File zipFile = new File((String)zipFileName);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            byte[] batchReport = response.getPdfReport();
            if (batchReport != null && batchReport.length > 0) {
                this.addZipEntry(zos, "batch_report.pdf", batchReport);
            } else {
                Log.warn("Batch PDF report is empty; ignoring inclusion of {}", (Object)response.getPdfOutputFileName());
            }
            for (FileReport fr : response.getFileReports()) {
                byte[] filePdf = fr.getPdfReport();
                if (filePdf == null || filePdf.length == 0) {
                    Log.warn("File report PDF is empty for document {}; ignoring.", (Object)fr.getDocumentName());
                    continue;
                }
                String fileName = fr.getDocumentName() + "_report.pdf";
                this.addZipEntry(zos, fileName, filePdf);
            }
        }
        Log.info("Wrote batch ZIP at location: {}", (Object)zipFile.getAbsolutePath());
    }

    protected void writeReport(ValidationResponse response) throws IOException {
        File file = new File(response.getPdfOutputFileName());
        try (FileOutputStream stream = new FileOutputStream(file);){
            ((OutputStream)stream).write(response.getPdfReport());
        }
        Log.info("Wrote report at location: {}", (Object)file.getAbsolutePath());
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
    }

    private static class ResponseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ResponseException(ValidationResponse response) {
            super("Got an error from server: " + response.getError());
        }
    }
}

