/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import de.intarsys.asn1.x509.Name;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;

public class IssuerAndSerialNumber
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public static IssuerAndSerialNumber create(Name issuer, CertificateSerialNumber serialNumber) {
        IssuerAndSerialNumber result = (IssuerAndSerialNumber)FACTORY.createNew();
        result.setIssuer(issuer);
        result.setSerialNumber(serialNumber);
        return result;
    }

    public IssuerAndSerialNumber copy() throws IOException {
        return (IssuerAndSerialNumber)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public Name getIssuer() {
        return (Name)Name.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public CertificateSerialNumber getSerialNumber() {
        ASN1ValueHolder number = this.getValueHolder().getChild(1);
        return (CertificateSerialNumber)CertificateSerialNumber.FACTORY.create(number);
    }

    public void setIssuer(Name issuer) {
        this.getValueHolder().setChild(0, issuer);
    }

    public void setSerialNumber(CertificateSerialNumber serialNumber) {
        this.getValueHolder().setChild(1, serialNumber);
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendMember("issuer", (Object)this.getIssuer(), null);
        printer.appendMember("serialNumber", (Object)this.getSerialNumber(), null);
    }

    public static class Factory
    extends ASN1Based.Factory<IssuerAndSerialNumber> {
    }
}

