/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.CMSContent;
import de.intarsys.asn1.model.ASN1Based;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncapsulatedContentInfo
extends CMS {
    private static final Logger Log = LoggerFactory.getLogger(EncapsulatedContentInfo.class);
    public static final Factory FACTORY = new Factory();

    @Override
    public EncapsulatedContentInfo copy() throws IOException {
        return (EncapsulatedContentInfo)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public byte[] getContentBytes() {
        CMSContent content = this.getContentObject();
        if (content == null) {
            return null;
        }
        try {
            return content.getBytes();
        }
        catch (IOException e) {
            Log.warn("Unable to retrieve contents.", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.setContentTypeData();
    }

    public boolean isContentTypeData() {
        return this.isData();
    }

    @Override
    public void setContent(ASN1Encodable content) {
        super.setContent(content);
    }

    public void setContent(byte[] content) {
        this.setContent((ASN1Encodable)new DEROctetString(content));
    }

    public void setContentTypeData() {
        this.ensureContentType(CMSObjectIdentifiers.data);
    }

    public static class Factory
    extends ASN1Based.Factory<EncapsulatedContentInfo> {
    }
}

