/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.form.model;

import de.intarsys.tools.form.model.FieldType;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.List;

public class FieldTypes {
    public static final FieldType TEXT = new FieldType("text");
    public static final FieldType NUMBER = new FieldType("number");
    public static final FieldType DATETIME = new FieldType("datetime");
    public static final FieldType IMAGE = new FieldType("image");
    public static final FieldType SIGNATURE = new FieldType("signature");
    public static final FieldType CHECKBOX = new FieldType("checkbox");
    private static List<FieldType> REGISTRY = new ArrayList<FieldType>();

    public static FieldType create(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return FieldTypes.lookup((String)value);
        }
        if (value instanceof IArgs) {
            IArgs args = (IArgs)value;
            FieldType type = FieldTypes.getFieldType(args);
            return new FieldType(type.getId(), args);
        }
        throw new IllegalArgumentException("unsupported field type " + value);
    }

    public static FieldType getFieldType(IArgs args) {
        String typeName = ArgTools.getString((IArgs)args, (String)"type", null);
        FieldType type = FieldTypes.lookup(typeName);
        if (type == null) {
            throw new IllegalArgumentException("unknown field type " + typeName);
        }
        return type;
    }

    public static FieldType lookup(String id) {
        return REGISTRY.stream().filter(type -> type.getId().equals(id)).findAny().orElse(null);
    }

    private FieldTypes() {
    }

    static {
        REGISTRY.add(TEXT);
        REGISTRY.add(NUMBER);
        REGISTRY.add(DATETIME);
        REGISTRY.add(IMAGE);
        REGISTRY.add(SIGNATURE);
        REGISTRY.add(CHECKBOX);
    }
}

