/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.document.standard;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.processor.document.standard.PACKAGE;
import de.intarsys.processor.document.standard.SaveSelectorFactory;
import de.intarsys.tools.activity.RequestFile;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorUsage;
import de.intarsys.tools.locator.TransientLocator;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reporter.Reporter;
import java.io.IOException;

public class SaveSelector
extends CommonDocumentProcessor {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private String applicationContext;
    private IDocumentType documentType;
    private String filterPath = null;
    private ILocator locator;
    private ILocator searchLocator;

    protected SaveSelector(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    @Override
    protected Object basicGetResult() {
        return this.getLocator();
    }

    @Override
    protected void basicRun() {
        boolean firstTry = true;
        while (true) {
            boolean isReadOnly = false;
            String localName = this.getDocument().getShortName();
            boolean currentlyOpen = false;
            if (!(this.locator instanceof TransientLocator)) {
                if (this.locator.equals(this.getDocument().getLocator())) {
                    isReadOnly = this.locator.isReadOnly();
                    localName = this.getDocument().getShortName();
                } else {
                    isReadOnly = this.locator.isReadOnly();
                    localName = this.locator.getName();
                    IDocument idoc = this.getDocument().getType().lookupDocument(this.locator);
                    if (idoc != null && idoc != this.getDocument()) {
                        currentlyOpen = true;
                    }
                }
            }
            if (!firstTry && isReadOnly) {
                Reporter.get().reportMessage(Msg.getString("SaveSelector.TitleSaveAs", new Object[0]), Msg.getString("SaveSelector.SaveAsIsReadOnly", new Object[]{localName}), 0);
            } else if (currentlyOpen) {
                Reporter.get().reportMessage(Msg.getString("SaveSelector.TitleSaveAs", new Object[0]), Msg.getString("SaveSelector.SaveAsCurrentlyOpen", new Object[]{localName}), 0);
            }
            firstTry = false;
            if (!(this.locator instanceof TransientLocator) && !isReadOnly && !currentlyOpen) break;
            this.locator = this.requestLocator();
            if (this.locator == null) {
                this.cancel();
                return;
            }
            this.filterPath = this.locator.getParent().getPath();
        }
        this.ok();
    }

    @Override
    protected void basicStop() throws Exception {
        if (this.getLocator() != null) {
            LocatorUsage.get().setLastLocator("save", this.getLocator());
            LocatorUsage.get().setLastLocator("save", this.getDocument().getType().getId(), this.getLocator());
            LocatorUsage.get().setLastLocator("any", this.getDocument().getType().getId(), this.getLocator());
            LocatorUsage.get().setLastLocator("save", this.getApplicationContext(), this.getLocator());
            LocatorUsage.get().setLastLocator("any", this.getApplicationContext(), this.getLocator());
        }
        super.basicStop();
    }

    public String getApplicationContext() {
        return this.applicationContext == null ? LocatorUsage.get().getSharedContext() : this.applicationContext;
    }

    public IDocumentType getDocumentType() {
        if (this.documentType == null) {
            return this.getDocument().getType();
        }
        return this.documentType;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public ILocator getSearchLocator() {
        return this.searchLocator;
    }

    protected String guiQueryFilenameSave() {
        String[] names;
        String[] extensions;
        IMessage title = Msg.getMessage("SaveSelector.TitleSaveAs", new Object[0]);
        if (this.filterPath == null) {
            if (this.getSearchLocator() != null) {
                ILocator current;
                for (current = this.getSearchLocator(); current != null && !current.isDirectory(); current = current.getParent()) {
                }
                this.filterPath = current != null ? current.getPath() : System.getProperty("user.dir");
            } else {
                this.filterPath = System.getProperty("user.dir");
            }
        }
        if (this.getDocumentType() != null) {
            extensions = DocumentTools.getFilterExtensions((IDocumentType)this.getDocumentType());
            names = DocumentTools.getFilterNames((IDocumentType)this.getDocumentType());
        } else {
            extensions = DocumentTools.getAllFilterExtensions();
            names = DocumentTools.getAllFilterNames();
        }
        return RequestFile.requestFileSave((IMessage)title, (String[])extensions, (String[])names, (String)this.filterPath, (String)this.locator.getName(), (boolean)true);
    }

    @Override
    protected SaveSelectorFactory myFactory() {
        return (SaveSelectorFactory)this.getFactory();
    }

    protected ILocator requestLocator() {
        String filename = this.guiQueryFilenameSave();
        if (filename == null) {
            return null;
        }
        try {
            return DocumentEnvironment.get().getLocatorFactory().createLocator(filename);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setApplicationContext(String applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setDocumentType(IDocumentType documentType) {
        this.documentType = documentType;
    }

    public void setLocator(ILocator locator) {
        this.locator = locator;
    }

    public void setSearchLocator(ILocator parent) {
        this.searchLocator = parent;
    }
}

