/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.document.standard;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.processor.document.standard.ICreator;
import de.intarsys.processor.document.standard.PACKAGE;
import de.intarsys.tools.exception.EncodedRuntimeException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.LocatorUsage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.Reporter;

public class DocumentCreator
extends CommonProcessor
implements ICreator {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IDocument document;
    private String locatorRecentContext = null;

    public DocumentCreator(IFactory factory) {
        super(factory);
    }

    protected Object basicGetResult() {
        return this.document;
    }

    @Override
    protected void basicRun() {
        IProgressMonitor monitor = Reporter.get().reportActivityStart(Msg.getMessage("DocumentCreator.CreateNewDocument", new Object[0]), 0);
        IDocumentType documentType = DocumentTools.getDocumentType((IArgs)this.getArgs(), (String)"documentType", null);
        if (documentType == null) {
            throw new EncodedRuntimeException("ProcessFailed", "document type not found");
        }
        try {
            IDocument newDocument = documentType.createNew(this.getArgs());
            this.setDocument(newDocument);
            if (this.getDocument() != null) {
                this.getDocument().setAttribute((Object)LocatorUsage.ATTR_LOCATORRECENTCONTEXT, (Object)this.getLocatorRecentContext());
            }
            Reporter.get().reportStatus(Msg.getString("DocumentCreator.CreatedNewDocument", new Object[0]), 0);
            this.ok();
        }
        catch (Exception e) {
            String message = Msg.getString("DocumentCreator.ErrorCreatingDocument", new Object[]{e.getMessage()});
            throw new EncodedRuntimeException("ProcessFailed", message, (Throwable)e);
        }
        finally {
            monitor.end();
        }
    }

    @Override
    public IDocument getDocument() {
        return this.document;
    }

    public String getLocatorRecentContext() {
        return this.locatorRecentContext;
    }

    protected void setDocument(IDocument paramDocument) {
        this.document = paramDocument;
    }

    public void setLocatorRecentContext(String paramLocatorRecentContext) {
        this.locatorRecentContext = paramLocatorRecentContext;
    }
}

