/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.ssl;

import de.intarsys.security.app.validation.ValidationTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.jca.device.DeviceJCAProvider;
import de.intarsys.security.jca.device.DeviceSignerPrivateKey;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.streaming.StreamingTools;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.net.ssl.X509KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceBasedKeyManager
implements X509KeyManager {
    private static final Logger Log = LoggerFactory.getLogger(DeviceBasedKeyManager.class);
    private IDevice device;
    private IArgs signerArgs;

    public static DeviceBasedKeyManager create(IDevice device) throws GeneralSecurityException, IOException {
        return DeviceBasedKeyManager.create(device, (IArgs)Args.create());
    }

    public static DeviceBasedKeyManager create(IDevice device, IArgs signerArgs) throws GeneralSecurityException, IOException {
        DeviceBasedKeyManager keyManager = new DeviceBasedKeyManager();
        keyManager.init(device, signerArgs);
        return keyManager;
    }

    private DeviceBasedKeyManager() {
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.getPrincipalStream().filter(principal -> {
            IX509PublicKeyCertificate certificate = principal.getX509PublicKeyCertificate();
            if (certificate == null) {
                return false;
            }
            return Arrays.asList(keyType).contains(certificate.getPublicKey().getAlgorithm());
        }).map(principal -> principal.getId()).findFirst().orElse(null);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        IX509Certificate[] certificatePath;
        IX509PublicKeyCertificate certificate;
        Optional<IX509Principal> principal = this.getPrincipal(alias);
        if (principal.isPresent() && (certificate = principal.get().getX509PublicKeyCertificate()) != null && (certificatePath = ValidationTools.getCertificatePath((IX509Certificate)certificate, (boolean)true)) != null) {
            try {
                return CertificateTools.toJavaCerts((IX509Certificate[])certificatePath);
            }
            catch (CertificateException e) {
                Log.warn(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return (String[])this.getPrincipalStream().filter(principal -> {
            IX509PublicKeyCertificate certificate = principal.getX509PublicKeyCertificate();
            if (certificate == null) {
                return false;
            }
            return keyType.equals(certificate.getPublicKey().getAlgorithm());
        }).map(principal -> principal.getId()).toArray(String[]::new);
    }

    protected IDevice getDevice() {
        return this.device;
    }

    protected Optional<IX509Principal> getPrincipal(String id) {
        return this.getPrincipalStream().filter(principal -> id.equals(principal.getId())).findFirst();
    }

    protected Stream<IX509Principal> getPrincipalStream() {
        IPrincipalFilter principalFilter = principal -> principal instanceof IX509Principal;
        return StreamingTools.asStream(this.device.listPrincipals(principalFilter)).map(IX509Principal.class::cast);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        Optional<IX509Principal> principal = this.getPrincipal(alias);
        if (!principal.isPresent()) {
            return null;
        }
        Args args = this.getSignerArgs() == null ? Args.create() : this.getSignerArgs().copy();
        ArgTools.putPath((IArgs)args, (String)"signerIdentifier", (Object)principal.get().getX509PublicKeyCertificate());
        return DeviceSignerPrivateKey.create(this.device, (IArgs)args, principal.get());
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return new String[0];
    }

    protected IArgs getSignerArgs() {
        return this.signerArgs;
    }

    protected void init(IDevice device, IArgs signerArgs) throws GeneralSecurityException, IOException {
        this.device = device;
        this.signerArgs = signerArgs;
    }

    static {
        DeviceJCAProvider.ensureRegistered();
    }
}

