/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.xmp;

import org.jempbox.xmp.pdfa.PropertyPDFAProperty;
import org.jempbox.xmp.pdfa.PropertyPDFASchema;
import org.jempbox.xmp.pdfa.XMPSchemaPDFAExtension;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionSchemaDescriptionBuilder {
    private XMPSchemaPDFAExtension extensions;
    private PropertyPDFASchema schema;

    public ExtensionSchemaDescriptionBuilder(XMPSchemaPDFAExtension extensions, String schemaDescription, String namespaceURI, String prefix) {
        this.extensions = extensions;
        this.schema = this.createExtensionSchema(schemaDescription, namespaceURI, prefix);
    }

    private PropertyPDFASchema createExtensionSchema(String schemaDescription, String namespaceURI, String prefix) {
        PropertyPDFASchema schema = new PropertyPDFASchema(this.newCollectionElement());
        if (schemaDescription != null) {
            schema.setSchema(schemaDescription);
        }
        schema.setNamespaceURI(namespaceURI);
        schema.setPrefix(prefix);
        Element propertyElement = this.getOrAppendChild(this.extensions.getElement(), "pdfaExtension:schemas");
        Element bag = this.getOrAppendChild(propertyElement, "rdf:Bag");
        bag.appendChild(schema.getElement());
        return schema;
    }

    private Element getOrAppendChild(Element parent, String tagName) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !tagName.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        Element child = this.newElement(tagName);
        parent.appendChild(child);
        return child;
    }

    public void addProperty(String name, String valueType, String category, String description) {
        PropertyPDFAProperty property = new PropertyPDFAProperty(this.newCollectionElement());
        property.setName(name);
        property.setValueType(valueType);
        property.setCategory(category);
        property.setDescription(description);
        this.schema.addProperty(property);
    }

    private Element newElement(String tagName) {
        return this.extensions.getElement().getOwnerDocument().createElement(tagName);
    }

    private Element newCollectionElement() {
        Element element = this.newElement("rdf:li");
        element.setAttribute("rdf:parseType", "Resource");
        return element;
    }
}

