/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.pd.PDSignatureReference;
import de.intarsys.pdf.pd.PDTransformMethod;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.ISignatureContainerEntryDefaultStateFactory;
import de.intarsys.security.app.validation.ISignatureEntryValidatorFactory;
import de.intarsys.security.app.validation.common.SignatureEntryDefaultStateFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.pdf.common.PDFAdditionalInfoDefinition;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.method.pdf.validation.PDFSignatureEntryValidatorFactory;
import de.intarsys.security.signature.CommonSignatureEntryAttributes;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfo;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfoDefinition;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfoSet;
import de.intarsys.security.signature.attribute.IAttributeMap;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class PDFSignatureEntry
extends PDFSignatureContainerEntry
implements ISignatureEntry,
IAdditionalInfoSet,
IStringEvaluator {
    public static final String DIGEST_ALG_SHA1 = "SHA1";
    private static final PDFAdditionalInfoDefinition definition = new PDFAdditionalInfoDefinition();
    private final ISignatureEntry basicSignatureEntry;

    protected PDFSignatureEntry(PDFSignatureContainer signatureContainer, PDSignature pdSignature, ISignatureEntry signatureEntry) {
        super(signatureContainer, pdSignature);
        this.basicSignatureEntry = signatureEntry;
        this.initVerificationReportAttributes();
    }

    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        String value = this.getValue(expression);
        if (value == null) {
            return "";
        }
        return StringTools.safeString((Object)value);
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == ISignatureEntryValidatorFactory.class) {
            return (T)new PDFSignatureEntryValidatorFactory();
        }
        if (clazz == ISignatureContainerEntryDefaultStateFactory.class) {
            return (T)new SignatureEntryDefaultStateFactory();
        }
        return super.getAdapter(clazz);
    }

    public List<IX509PublicKeyCertificate> getAdditionalCertificates() throws CertificateException, IOException {
        return this.basicSignatureEntry.getAdditionalCertificates();
    }

    public ISignatureEntry getBasicSignatureEntry() {
        return this.basicSignatureEntry;
    }

    public String getContentType() {
        return this.basicSignatureEntry.getContentType();
    }

    public Date getCreationDate() {
        return this.getSigningTime();
    }

    public IAdditionalInfoDefinition getDefinition() {
        return definition;
    }

    @Override
    public AlgorithmSpec getHashAlgorithmSpec() {
        return this.basicSignatureEntry.getHashAlgorithmSpec();
    }

    public String getLocation() {
        return this.getPDSignature().getLocation();
    }

    public String getReason() {
        return this.getPDSignature().getReason();
    }

    public AlgorithmSpec<SignatureAlgorithm> getSignatureAlgorithmSpec() {
        return this.basicSignatureEntry.getSignatureAlgorithmSpec();
    }

    public byte[] getSignatureEncoded() {
        return this.basicSignatureEntry.getSignatureEncoded();
    }

    public PDSignatureReference getSignatureReference(COSName transformMethod) {
        PDSignature signature = this.getPDSignature();
        List signatureReferences = signature.getSignatureReferences();
        if (signatureReferences != null && !signatureReferences.isEmpty()) {
            for (PDSignatureReference reference : signatureReferences) {
                PDTransformMethod method = reference.getTransformMethod();
                if (!transformMethod.equals((Object)method.cosGetObject())) continue;
                return reference;
            }
        }
        return null;
    }

    public IAttributeMap getSignedAttributes() {
        return this.basicSignatureEntry.getSignedAttributes();
    }

    public IX509PublicKeyCertificate getSignerCertificate() throws CertificateException, IOException {
        return this.basicSignatureEntry.getSignerCertificate();
    }

    public Date getSigningTime() {
        Date date = this.basicSignatureEntry.getSigningTime();
        if (date != null) {
            return date;
        }
        try {
            CDSDate cdsDate = this.getPDSignature().getDate();
            if (cdsDate != null) {
                return cdsDate.toDate();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public byte[] getTimestampInput() {
        return this.getSignatureEncoded();
    }

    public IAttributeMap getUnsignedAttributes() {
        return this.basicSignatureEntry.getUnsignedAttributes();
    }

    public String getValue(IAdditionalInfo info) {
        return this.getPDSignature().getFieldString(COSName.create((String)info.getName()), "");
    }

    public String getValue(String name) {
        return this.getPDSignature().getFieldString(COSName.create((String)name), "");
    }

    protected void initVerificationReportAttributes() {
        String fieldName = this.getPDSignature().getAcroFormField().getQualifiedName();
        CommonSignatureEntryAttributes.setPDFFieldName((ISignatureEntry)this, (String)fieldName);
        boolean visible = false;
        for (PDAnnotation annot : this.getPDSignature().getAcroFormField().getAnnotations()) {
            if (annot.isHidden() || annot.isInvisible() || annot.isNoView()) continue;
            visible = true;
            break;
        }
        CommonSignatureEntryAttributes.setPDFSignatureVisible((ISignatureEntry)this, (boolean)visible);
    }

    public boolean isCertificationSignature() {
        return this.getSignatureReference(PDTransformMethod.DK_DocMDP) != null;
    }

    public void setValue(IAdditionalInfo info, String value) {
    }

    public void setValue(String infoDefinitionName, String value) {
    }
}

