/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.streaming;

import de.intarsys.tools.exception.ExceptionTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamingTools {
    public static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        return StreamingTools.asStream(sourceIterator, false);
    }

    public static <T> Stream<T> asStream(Iterator<T> sourceIterator, boolean parallel) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }

    public static <T> Stream<T> concatIfEmpty(Stream<T> stream, Supplier<Stream<T>> additional) {
        List<T> elements = stream.toList();
        if (!elements.isEmpty()) {
            return elements.stream();
        }
        return additional.get();
    }

    public static <T> Stream<T> concatLazy(Stream<T> stream, final Future<Stream<T>> additional) {
        return StreamingTools.concatLazy(stream, new Supplier<Stream<T>>(){

            @Override
            public Stream<T> get() {
                try {
                    return (Stream)additional.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw ExceptionTools.wrap(e);
                }
                catch (ExecutionException e) {
                    throw ExceptionTools.wrap(e);
                }
            }
        });
    }

    public static <T> Stream<T> concatLazy(Stream<T> stream, Supplier<Stream<T>> additional) {
        return Stream.concat(stream, additional.get());
    }

    public static <T> Stream<T> copyStream(Collection<T> list) {
        if (list == null) {
            return Stream.empty();
        }
        return new ArrayList<T>(list).stream();
    }

    public static <T> Stream<T> safeStream(Collection<T> list) {
        if (list == null) {
            return Stream.empty();
        }
        return list.stream();
    }

    private StreamingTools() {
    }
}

