/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.progress;

import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.progress.SubProgressMonitor;
import de.intarsys.tools.string.StringTools;

public class BaseProgressMonitor
implements IProgressMonitor {
    private static final int HUNDRED_PERCENT = 100;
    private volatile String taskName;
    private volatile String subTaskName;
    private volatile float work = -1.0f;
    private volatile boolean cancelled;
    private volatile float worked;
    private volatile boolean started;
    private volatile boolean atEnd;

    @Override
    public void begin(String name, float totalWork) {
        if (this.started) {
            throw new InvalidRequestException("monitor already started");
        }
        this.started = true;
        this.taskName = name;
        this.work = totalWork;
        this.worked = 0.0f;
    }

    @Override
    public void end() {
        if (this.work > this.worked) {
            this.worked(this.work - this.worked);
        }
        this.atEnd = true;
        this.started = false;
        this.worked = this.work;
        this.subTaskName = null;
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        if (!StringTools.isEmpty(this.getTaskName())) {
            sb.append(this.getTaskName());
        }
        if (!StringTools.isEmpty(this.getSubTaskName())) {
            sb.append(" - ");
            sb.append(this.getSubTaskName());
        }
        return sb.toString();
    }

    public String getSubTaskName() {
        return this.subTaskName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public float getWork() {
        return this.work;
    }

    public float getWorked() {
        return this.worked;
    }

    public float getWorkedPercent() {
        float tmpWork = this.getWork();
        float tmpWorked = this.getWorked();
        if (tmpWork == 0.0f) {
            return 0.0f;
        }
        return tmpWorked * 100.0f / tmpWork;
    }

    public boolean isAtEnd() {
        return this.atEnd;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public IProgressMonitor spawn(float work) {
        return new SubProgressMonitor(this, work);
    }

    @Override
    public void subTask(String name) {
        this.subTaskName = name;
    }

    @Override
    public void worked(float amount) {
        if (!this.started) {
            throw new InvalidRequestException("monitor not started");
        }
        this.worked += amount;
        if (this.worked >= this.work) {
            this.worked = this.work;
            this.atEnd = true;
        }
        if (this.worked < 0.0f) {
            this.worked = 0.0f;
        }
    }
}

