/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.content.ICharsetAccess;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;

public class StreamLocator
extends CommonLocator
implements ICharsetAccess {
    private boolean inputUsed;
    private boolean outputUsed;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private String fullName;
    private String charset;

    public StreamLocator(InputStream is, OutputStream os, String fullName) {
        this.inputStream = is;
        this.outputStream = os;
        this.setFullName(fullName);
    }

    public StreamLocator(InputStream is, OutputStream os, String name, String type) {
        this(is, os, (String)(StringTools.isEmpty(type) ? name : name + "." + type));
    }

    public StreamLocator(InputStream stream, String fullname) {
        this(stream, (OutputStream)null, fullname);
    }

    public StreamLocator(InputStream stream, String name, String type) {
        this(stream, null, name, type);
    }

    public StreamLocator(OutputStream stream, String fullname) {
        this(null, stream, fullname);
    }

    public StreamLocator(OutputStream stream, String name, String type) {
        this(null, stream, name, type);
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return this.inputStream != null;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public ILocator getChild(String child) {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputUsed) {
            throw new IOException("input already requested");
        }
        this.inputUsed = true;
        return this.inputStream;
    }

    @Override
    public String getName() {
        return PathTools.getName(this.fullName);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputUsed) {
            throw new IOException("output already requested");
        }
        this.outputUsed = true;
        return this.outputStream;
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public String getPath() {
        return this.fullName;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getCharset() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getCharset());
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        return new InputStreamReader(this.getInputStream(), encoding);
    }

    @Override
    public Writer getWriter() throws IOException {
        if (this.getCharset() == null) {
            return new OutputStreamWriter(this.getOutputStream());
        }
        return new OutputStreamWriter(this.getOutputStream(), this.getCharset());
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        return new OutputStreamWriter(this.getOutputStream(), encoding);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        if (super.isReadOnly()) {
            return true;
        }
        return this.outputStream == null;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) {
        return new ILocator[0];
    }

    @Override
    public void rename(String newName) throws IOException {
        this.setFullName(newName);
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected void setFullName(String newName) {
        this.fullName = newName;
    }

    @Override
    public void synch() {
    }

    @Override
    public URI toURI() {
        return null;
    }
}

